/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class PatternAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final PatternAnalyzer analyzer;

    @Inject
    public PatternAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Version esVersion = indexSettings.getAsVersion("index.version.created", Version.CURRENT);
        CharArraySet defaultStopwords = esVersion.onOrAfter(Version.V_1_0_0_RC1) ? CharArraySet.EMPTY_SET : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        boolean lowercase = settings.getAsBoolean("lowercase", (Boolean)true);
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords, this.version);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new ElasticsearchIllegalArgumentException("Analyzer [" + name + "] of type pattern must have a `pattern` set");
        }
        Pattern pattern = Regex.compile(sPattern, settings.get("flags"));
        this.analyzer = new PatternAnalyzer(this.version, pattern, lowercase, stopWords);
    }

    @Override
    public PatternAnalyzer get() {
        return this.analyzer;
    }

    private static final class PatternAnalyzer
    extends Analyzer {
        private final org.apache.lucene.util.Version version;
        private final Pattern pattern;
        private final boolean lowercase;
        private final CharArraySet stopWords;

        PatternAnalyzer(org.apache.lucene.util.Version version, Pattern pattern, boolean lowercase, CharArraySet stopWords) {
            this.version = version;
            this.pattern = pattern;
            this.lowercase = lowercase;
            this.stopWords = stopWords;
        }

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String s, Reader reader) {
            Analyzer.TokenStreamComponents source = new Analyzer.TokenStreamComponents(new PatternTokenizer(reader, this.pattern, -1));
            TokenFilter result = null;
            if (this.lowercase) {
                result = new LowerCaseFilter(this.version, source.getTokenStream());
            }
            result = new StopFilter(this.version, result == null ? source.getTokenStream() : result, this.stopWords);
            return new Analyzer.TokenStreamComponents(source.getTokenizer(), result);
        }
    }
}

