/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.util.Map;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.bloom.BloomFilterFactory;
import org.apache.lucene.codecs.bloom.BloomFilteringPostingsFormat;
import org.apache.lucene.codecs.bloom.FuzzySet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.postingsformat.AbstractPostingsFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.settings.IndexSettings;

public class BloomFilterLucenePostingsFormatProvider
extends AbstractPostingsFormatProvider {
    private final float desiredMaxSaturation;
    private final float saturationLimit;
    private final PostingsFormatProvider delegate;
    private final BloomFilteringPostingsFormat postingsFormat;

    @Inject
    public BloomFilterLucenePostingsFormatProvider(@IndexSettings Settings indexSettings, @Nullable Map<String, PostingsFormatProvider.Factory> postingFormatFactories, @Assisted String name, @Assisted Settings postingsFormatSettings) {
        super(name);
        this.desiredMaxSaturation = postingsFormatSettings.getAsFloat("desired_max_saturation", Float.valueOf(0.1f)).floatValue();
        this.saturationLimit = postingsFormatSettings.getAsFloat("saturation_limit", Float.valueOf(0.9f)).floatValue();
        this.delegate = PostingsFormatProvider.Helper.lookup(indexSettings, postingsFormatSettings.get("delegate"), postingFormatFactories);
        this.postingsFormat = new BloomFilteringPostingsFormat(this.delegate.get(), new CustomBloomFilterFactory(this.desiredMaxSaturation, this.saturationLimit));
    }

    public float desiredMaxSaturation() {
        return this.desiredMaxSaturation;
    }

    public float saturationLimit() {
        return this.saturationLimit;
    }

    public PostingsFormatProvider delegate() {
        return this.delegate;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }

    public static class CustomBloomFilterFactory
    extends BloomFilterFactory {
        private final float desiredMaxSaturation;
        private final float saturationLimit;

        public CustomBloomFilterFactory() {
            this(0.1f, 0.9f);
        }

        CustomBloomFilterFactory(float desiredMaxSaturation, float saturationLimit) {
            this.desiredMaxSaturation = desiredMaxSaturation;
            this.saturationLimit = saturationLimit;
        }

        @Override
        public FuzzySet getSetForField(SegmentWriteState state, FieldInfo info) {
            return FuzzySet.createSetBasedOnQuality(state.segmentInfo.getDocCount(), this.desiredMaxSaturation);
        }

        @Override
        public boolean isSaturated(FuzzySet bloomFilter, FieldInfo fieldInfo) {
            return bloomFilter.getSaturation() > this.saturationLimit;
        }
    }

    public static final class Defaults {
        public static final float MAX_SATURATION = 0.1f;
        public static final float SATURATION_LIMIT = 0.9f;
    }
}

