/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.util.BloomFilter;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.Store;

public final class BloomFilterPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "XBloomFilter";
    public static final int BLOOM_CODEC_VERSION = 1;
    public static final int BLOOM_CODEC_VERSION_CHECKSUM = 2;
    public static final int BLOOM_CODEC_VERSION_CURRENT = 2;
    static final String BLOOM_EXTENSION = "blm";
    private BloomFilter.Factory bloomFilterFactory = BloomFilter.Factory.DEFAULT;
    private PostingsFormat delegatePostingsFormat;

    public BloomFilterPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilter.Factory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public BloomFilteredFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new BloomFilteredFieldsConsumer(this.delegatePostingsFormat.fieldsConsumer(state), state, this.delegatePostingsFormat);
    }

    @Override
    public BloomFilteredFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    public PostingsFormat getDelegate() {
        return this.delegatePostingsFormat;
    }

    class WrappedTermsConsumer
    extends TermsConsumer {
        private TermsConsumer delegateTermsConsumer;
        private BloomFilter bloomFilter;

        public WrappedTermsConsumer(TermsConsumer termsConsumer, BloomFilter bloomFilter) {
            this.delegateTermsConsumer = termsConsumer;
            this.bloomFilter = bloomFilter;
        }

        @Override
        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            return this.delegateTermsConsumer.startTerm(text);
        }

        @Override
        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (stats.docFreq > 0) {
                this.bloomFilter.put(text);
            }
            this.delegateTermsConsumer.finishTerm(text, stats);
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            this.delegateTermsConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        @Override
        public Comparator<BytesRef> getComparator() throws IOException {
            return this.delegateTermsConsumer.getComparator();
        }
    }

    final class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, BloomFilter> bloomFilters = new HashMap<FieldInfo, BloomFilter>();
        private SegmentWriteState state;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state, PostingsFormat delegatePostingsFormat) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        FieldsConsumer getDelegate() {
            return this.delegateFieldsConsumer;
        }

        @Override
        public TermsConsumer addField(FieldInfo field) throws IOException {
            BloomFilter bloomFilter = BloomFilterPostingsFormat.this.bloomFilterFactory.createFilter(this.state.segmentInfo.getDocCount());
            if (bloomFilter != null) {
                assert (!this.bloomFilters.containsKey(field));
                this.bloomFilters.put(field, bloomFilter);
                return new WrappedTermsConsumer(this.delegateFieldsConsumer.addField(field), bloomFilter);
            }
            return this.delegateFieldsConsumer.addField(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, BloomFilter>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, BloomFilter>>();
            for (Map.Entry<FieldInfo, BloomFilter> entry : this.bloomFilters.entrySet()) {
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, BloomFilterPostingsFormat.BLOOM_EXTENSION);
            IndexOutput bloomOutput = null;
            try {
                bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);
                CodecUtil.writeHeader(bloomOutput, BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 2);
                bloomOutput.writeString(BloomFilterPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    BloomFilter bloomFilter = (BloomFilter)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
                CodecUtil.writeFooter(bloomOutput);
            }
            catch (Throwable throwable) {
                IOUtils.close(bloomOutput);
                throw throwable;
            }
            IOUtils.close(bloomOutput);
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, BloomFilter bloomFilter, FieldInfo fieldInfo) throws IOException {
            BloomFilter.serilaize(bloomFilter, bloomOutput);
        }
    }

    static final class BloomFilteredTermsEnum
    extends TermsEnum {
        private Terms delegateTerms;
        private TermsEnum delegateTermsEnum;
        private TermsEnum reuse;
        private BloomFilter filter;

        public BloomFilteredTermsEnum(Terms other, TermsEnum reuse, BloomFilter filter) {
            this.delegateTerms = other;
            this.reuse = reuse;
            this.filter = filter;
        }

        void reset(Terms others) {
            this.reuse = this.delegateTermsEnum;
            this.delegateTermsEnum = null;
            this.delegateTerms = others;
        }

        private TermsEnum getDelegate() throws IOException {
            if (this.delegateTermsEnum == null) {
                this.delegateTermsEnum = this.delegateTerms.iterator(this.reuse);
            }
            return this.delegateTermsEnum;
        }

        @Override
        public final BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        @Override
        public final Comparator<BytesRef> getComparator() {
            return this.delegateTerms.getComparator();
        }

        @Override
        public final boolean seekExact(BytesRef text) throws IOException {
            if (!this.filter.mightContain(text)) {
                return false;
            }
            return this.getDelegate().seekExact(text);
        }

        @Override
        public final TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        @Override
        public final void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        @Override
        public final BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        @Override
        public final long ord() throws IOException {
            return this.getDelegate().ord();
        }

        @Override
        public final int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        @Override
        public final long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docsAndPositions(liveDocs, reuse, flags);
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docs(liveDocs, reuse, flags);
        }
    }

    public static final class BloomFilteredTerms
    extends FilterAtomicReader.FilterTerms {
        private BloomFilter filter;

        public BloomFilteredTerms(Terms terms, BloomFilter filter) {
            super(terms);
            this.filter = filter;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (reuse != null && reuse instanceof BloomFilteredTermsEnum) {
                BloomFilteredTermsEnum bfte = (BloomFilteredTermsEnum)reuse;
                if (bfte.filter == this.filter) {
                    bfte.reset(this.in);
                    return bfte;
                }
                reuse = bfte.reuse;
            }
            BloomFilteredTermsEnum result = new BloomFilteredTermsEnum(this.in, reuse, this.filter);
            return result;
        }
    }

    public final class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, BloomFilter> bloomsByFieldName = new HashMap();

        FieldsProducer getDelegate() {
            return this.delegateFieldsProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, BloomFilterPostingsFormat.BLOOM_EXTENSION);
            ChecksumIndexInput bloomIn = null;
            boolean success = false;
            try {
                bloomIn = state.directory.openChecksumInput(bloomFileName, state.context);
                int version = CodecUtil.checkHeader(bloomIn, BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 1, 2);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName(bloomIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numBlooms = bloomIn.readInt();
                boolean load = true;
                Store.StoreDirectory storeDir = DirectoryUtils.getStoreDirectory(state.directory);
                if (storeDir != null && storeDir.codecService() != null) {
                    load = storeDir.codecService().isLoadBloomFilter();
                }
                if (load && state.context.context != IOContext.Context.MERGE) {
                    for (int i = 0; i < numBlooms; ++i) {
                        int fieldNum = bloomIn.readInt();
                        BloomFilter bloom = BloomFilter.deserialize(bloomIn);
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                        this.bloomsByFieldName.put(fieldInfo.name, bloom);
                    }
                    if (version >= 2) {
                        CodecUtil.checkFooter(bloomIn);
                    } else {
                        CodecUtil.checkEOF(bloomIn);
                    }
                }
                IOUtils.close(bloomIn);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(bloomIn, this.delegateFieldsProducer);
                throw throwable;
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        @Override
        public void close() throws IOException {
            this.delegateFieldsProducer.close();
        }

        @Override
        public Terms terms(String field) throws IOException {
            BloomFilter filter = this.bloomsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new BloomFilteredTerms(result, filter);
        }

        @Override
        public int size() {
            return this.delegateFieldsProducer.size();
        }

        @Override
        public long getUniqueTermCount() throws IOException {
            return this.delegateFieldsProducer.getUniqueTermCount();
        }

        @Override
        public long ramBytesUsed() {
            long size = this.delegateFieldsProducer.ramBytesUsed();
            for (BloomFilter bloomFilter : this.bloomsByFieldName.values()) {
                size += bloomFilter.getSizeInBytes();
            }
            return size;
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }
    }
}

