/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class AbstractAtomicNumericFieldData
implements AtomicNumericFieldData {
    private boolean isFloat;

    public AbstractAtomicNumericFieldData(boolean isFloat) {
        this.isFloat = isFloat;
    }

    @Override
    public ScriptDocValues getScriptValues() {
        if (this.isFloat) {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public BytesValues getBytesValues() {
        if (this.isFloat) {
            final DoubleValues values = this.getDoubleValues();
            return new BytesValues(values.isMultiValued()){
                private final BytesRef scratch;
                {
                    super(x0);
                    this.scratch = new BytesRef();
                }

                @Override
                public int setDocument(int docId) {
                    return values.setDocument(docId);
                }

                @Override
                public BytesRef nextValue() {
                    this.scratch.copyChars(Double.toString(values.nextValue()));
                    return this.scratch;
                }

                @Override
                public AtomicFieldData.Order getOrder() {
                    return values.getOrder();
                }
            };
        }
        final LongValues values = this.getLongValues();
        return new BytesValues(values.isMultiValued()){
            private final BytesRef scratch;
            {
                super(x0);
                this.scratch = new BytesRef();
            }

            @Override
            public int setDocument(int docId) {
                return values.setDocument(docId);
            }

            @Override
            public BytesRef nextValue() {
                this.scratch.copyChars(Long.toString(values.nextValue()));
                return this.scratch;
            }

            @Override
            public AtomicFieldData.Order getOrder() {
                return values.getOrder();
            }
        };
    }
}

