/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;

public abstract class LongValues {
    public static final LongValues EMPTY = new Empty();
    private final boolean multiValued;
    protected int docId;

    protected LongValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract int setDocument(int var1);

    public abstract long nextValue();

    public AtomicFieldData.Order getOrder() {
        return AtomicFieldData.Order.NUMERIC;
    }

    public static LongValues asLongValues(final DoubleValues values) {
        return new LongValues(values.isMultiValued()){

            @Override
            public int setDocument(int docId) {
                return values.setDocument(docId);
            }

            @Override
            public long nextValue() {
                return (long)values.nextValue();
            }
        };
    }

    private static final class Empty
    extends LongValues {
        public Empty() {
            super(false);
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public long nextValue() {
            throw new ElasticsearchIllegalStateException("Empty LongValues has no next value");
        }
    }

    public static abstract class WithOrdinals
    extends LongValues {
        protected final BytesValues.WithOrdinals ordinals;

        protected WithOrdinals(BytesValues.WithOrdinals ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
        }

        public abstract long getValueByOrd(long var1);

        @Override
        public int setDocument(int docId) {
            this.docId = docId;
            return this.ordinals.setDocument(docId);
        }

        @Override
        public long nextValue() {
            return this.getValueByOrd(this.ordinals.nextOrd());
        }
    }
}

