/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorBase;
import org.elasticsearch.search.MultiValueMode;

public final class FloatValuesComparator
extends DoubleValuesComparatorBase<Float> {
    private final float[] values;

    public FloatValuesComparator(IndexNumericFieldData<?> indexFieldData, float missingValue, int numHits, MultiValueMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        assert (indexFieldData.getNumericType().requiredBits() <= 32);
        this.values = new float[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        float v1 = this.values[slot1];
        float v2 = this.values[slot2];
        return Float.compare(v1, v2);
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = (float)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public Float value(int slot) {
        return Float.valueOf(this.values[slot]);
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + (float)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (float)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = (float)this.missingValue;
    }
}

