/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class SinglePackedOrdinals
extends Ordinals {
    private final PackedInts.Reader reader;
    private final long maxOrd;
    private long size = -1L;

    public SinglePackedOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        assert (builder.getNumMultiValuesDocs() == 0);
        this.maxOrd = builder.getMaxOrd();
        PackedInts.Mutable reader = PackedInts.getMutable(builder.maxDoc(), PackedInts.bitsRequired(this.maxOrd), acceptableOverheadRatio);
        PackedInts.copy(builder.getFirstOrdinals(), 0, reader, 0, builder.maxDoc(), 8192);
        this.reader = reader;
    }

    @Override
    public long ramBytesUsed() {
        if (this.size == -1L) {
            this.size = (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public BytesValues.WithOrdinals ordinals(Ordinals.ValuesHolder values) {
        return new Docs(this, values);
    }

    private static class Docs
    extends BytesValues.WithOrdinals {
        private final long maxOrd;
        private final PackedInts.Reader reader;
        private final Ordinals.ValuesHolder values;
        private long currentOrdinal;

        public Docs(SinglePackedOrdinals parent, Ordinals.ValuesHolder values) {
            super(false);
            this.maxOrd = parent.maxOrd;
            this.reader = parent.reader;
            this.values = values;
        }

        @Override
        public long getMaxOrd() {
            return this.maxOrd;
        }

        @Override
        public long getOrd(int docId) {
            this.currentOrdinal = this.reader.get(docId) - 1L;
            return this.currentOrdinal;
        }

        @Override
        public long nextOrd() {
            assert (this.currentOrdinal >= 0L);
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            this.currentOrdinal = this.reader.get(docId) - 1L;
            return 1 + (int)Math.min(this.currentOrdinal, 0L);
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.values.getValueByOrd(ord);
        }
    }
}

