/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;

final class BinaryDVNumericAtomicFieldData
extends AbstractAtomicNumericFieldData {
    private final BinaryDocValues values;
    private final IndexNumericFieldData.NumericType numericType;

    BinaryDVNumericAtomicFieldData(BinaryDocValues values, IndexNumericFieldData.NumericType numericType) {
        super(numericType.isFloatingPoint());
        this.values = values;
        this.numericType = numericType;
    }

    @Override
    public LongValues getLongValues() {
        if (this.numericType.isFloatingPoint()) {
            return LongValues.asLongValues(this.getDoubleValues());
        }
        return new LongValues(true){
            BytesRef bytes;
            final ByteArrayDataInput in;
            long[] longs;
            int i;
            int valueCount;
            {
                this.in = new ByteArrayDataInput();
                this.longs = new long[8];
                this.i = Integer.MAX_VALUE;
                this.valueCount = 0;
            }

            @Override
            public int setDocument(int docId) {
                this.bytes = BinaryDVNumericAtomicFieldData.this.values.get(docId);
                this.in.reset(this.bytes.bytes, this.bytes.offset, this.bytes.length);
                if (!this.in.eof()) {
                    long previousValue = this.longs[0] = ByteUtils.zigZagDecode(ByteUtils.readVLong(this.in));
                    this.valueCount = 1;
                    while (!this.in.eof()) {
                        this.longs = ArrayUtil.grow(this.longs, this.valueCount + 1);
                        long l = previousValue + ByteUtils.readVLong(this.in);
                        this.longs[this.valueCount++] = l;
                        previousValue = l;
                    }
                } else {
                    this.valueCount = 0;
                }
                this.i = 0;
                return this.valueCount;
            }

            @Override
            public long nextValue() {
                assert (this.i < this.valueCount);
                return this.longs[this.i++];
            }
        };
    }

    @Override
    public DoubleValues getDoubleValues() {
        if (!this.numericType.isFloatingPoint()) {
            return DoubleValues.asDoubleValues(this.getLongValues());
        }
        switch (this.numericType) {
            case FLOAT: {
                return new DoubleValues(true){
                    BytesRef bytes;
                    int i;
                    int valueCount;
                    {
                        this.i = Integer.MAX_VALUE;
                        this.valueCount = 0;
                    }

                    @Override
                    public int setDocument(int docId) {
                        this.bytes = BinaryDVNumericAtomicFieldData.this.values.get(docId);
                        assert (this.bytes.length % 4 == 0);
                        this.i = 0;
                        this.valueCount = this.bytes.length / 4;
                        return this.valueCount;
                    }

                    @Override
                    public double nextValue() {
                        assert (this.i < this.valueCount);
                        return ByteUtils.readFloatLE(this.bytes.bytes, this.bytes.offset + this.i++ * 4);
                    }
                };
            }
            case DOUBLE: {
                return new DoubleValues(true){
                    BytesRef bytes;
                    int i;
                    int valueCount;
                    {
                        this.i = Integer.MAX_VALUE;
                        this.valueCount = 0;
                    }

                    @Override
                    public int setDocument(int docId) {
                        this.bytes = BinaryDVNumericAtomicFieldData.this.values.get(docId);
                        assert (this.bytes.length % 8 == 0);
                        this.i = 0;
                        this.valueCount = this.bytes.length / 8;
                        return this.valueCount;
                    }

                    @Override
                    public double nextValue() {
                        assert (this.i < this.valueCount);
                        return ByteUtils.readDoubleLE(this.bytes.bytes, this.bytes.offset + this.i++ * 8);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public long ramBytesUsed() {
        return -1L;
    }

    @Override
    public void close() {
    }
}

