/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseDoubleValues;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class DoubleArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    protected long size = -1L;

    public static DoubleArrayAtomicFieldData empty() {
        return new Empty();
    }

    public DoubleArrayAtomicFieldData() {
        super(true);
    }

    @Override
    public void close() {
    }

    public static class Single
    extends DoubleArrayAtomicFieldData {
        private final DoubleArray values;

        public Single(DoubleArray values) {
            this.values = values;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static final class DoubleValues
        extends DenseDoubleValues {
            private final DoubleArray values;

            DoubleValues(DoubleArray values) {
                super(false);
                this.values = values;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static final class LongValues
        extends DenseLongValues {
            private final DoubleArray values;

            LongValues(DoubleArray values) {
                super(false);
                this.values = values;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class SingleFixedSet
    extends DoubleArrayAtomicFieldData {
        private final DoubleArray values;
        private final FixedBitSet set;

        public SingleFixedSet(DoubleArray values, FixedBitSet set) {
            this.values = values;
            this.set = set;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.ramBytesUsed() + RamUsageEstimator.sizeOf(this.set.getBits());
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final DoubleArray values;
            private final FixedBitSet set;

            DoubleValues(DoubleArray values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final DoubleArray values;
            private final FixedBitSet set;

            LongValues(DoubleArray values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends DoubleArrayAtomicFieldData {
        private final DoubleArray values;
        private final Ordinals ordinals;

        public WithOrdinals(DoubleArray values, Ordinals ordinals) {
            this.values = values;
            this.ordinals = ordinals;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 4L + this.values.ramBytesUsed() + this.ordinals.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final DoubleArray values;

            DoubleValues(DoubleArray values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(long ord) {
                assert (ord != -1L);
                return this.values.get(ord);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final DoubleArray values;

            LongValues(DoubleArray values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public final long getValueByOrd(long ord) {
                assert (ord != -1L);
                return (long)this.values.get(ord);
            }
        }
    }

    static class Empty
    extends DoubleArrayAtomicFieldData {
        Empty() {
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY_DOUBLES;
        }
    }
}

