/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class FSTBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    protected final Ordinals ordinals;
    private long size = -1L;
    private final FST<Long> fst;

    public FSTBytesAtomicFieldData(FST<Long> fst, Ordinals ordinals) {
        this.ordinals = ordinals;
        this.fst = fst;
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        if (this.size == -1L) {
            long size = this.ordinals.ramBytesUsed();
            this.size = size += this.fst == null ? 0L : this.fst.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.fst));
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        assert (this.fst != null);
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final FST<Long> fst;
        private final BytesRef scratch;
        protected final FST.BytesReader in;
        protected final FST.Arc<Long> firstArc = new FST.Arc();
        protected final FST.Arc<Long> scratchArc = new FST.Arc();
        protected final IntsRef scratchInts = new IntsRef();

        ValuesHolder(FST<Long> fst) {
            this.fst = fst;
            this.scratch = new BytesRef();
            this.in = fst.getBytesReader();
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            assert (ord != -1L);
            this.in.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            try {
                IntsRef output = Util.getByOutput(this.fst, ord, this.in, this.firstArc, this.scratchArc, this.scratchInts);
                this.scratch.offset = 0;
                this.scratch.length = 0;
                this.scratch.grow(output.length);
                Util.toBytesRef(output, this.scratch);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.scratch;
        }
    }
}

