/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.packed.AppendingDeltaPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class PackedArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    protected long size = -1L;

    public static PackedArrayAtomicFieldData empty() {
        return new Empty();
    }

    public PackedArrayAtomicFieldData() {
        super(false);
    }

    @Override
    public void close() {
    }

    public static class PagedSingleSparse
    extends PackedArrayAtomicFieldData {
        private final AppendingDeltaPackedLongBuffer values;
        private final FixedBitSet docsWithValue;

        public PagedSingleSparse(AppendingDeltaPackedLongBuffer values, FixedBitSet docsWithValue) {
            this.values = values;
            this.docsWithValue = docsWithValue;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed() + 16L;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.docsWithValue);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.docsWithValue);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final AppendingDeltaPackedLongBuffer values;
            private final FixedBitSet docsWithValue;

            DoubleValues(AppendingDeltaPackedLongBuffer values, FixedBitSet docsWithValue) {
                super(false);
                this.values = values;
                this.docsWithValue = docsWithValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.docsWithValue.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final AppendingDeltaPackedLongBuffer values;
            private final FixedBitSet docsWithValue;

            LongValues(AppendingDeltaPackedLongBuffer values, FixedBitSet docsWithValue) {
                super(false);
                this.values = values;
                this.docsWithValue = docsWithValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.docsWithValue.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return this.values.get(this.docId);
            }
        }
    }

    public static class PagedSingle
    extends PackedArrayAtomicFieldData {
        private final AppendingDeltaPackedLongBuffer values;

        public PagedSingle(AppendingDeltaPackedLongBuffer values) {
            this.values = values;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final AppendingDeltaPackedLongBuffer values;

            DoubleValues(AppendingDeltaPackedLongBuffer values) {
                super(false);
                this.values = values;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends DenseLongValues {
            private final AppendingDeltaPackedLongBuffer values;

            LongValues(AppendingDeltaPackedLongBuffer values) {
                super(false);
                this.values = values;
            }

            @Override
            public long nextValue() {
                return this.values.get(this.docId);
            }
        }
    }

    public static class Single
    extends PackedArrayAtomicFieldData {
        private final PackedInts.Mutable values;
        private final long minValue;

        public Single(PackedInts.Mutable values, long minValue) {
            this.values = values;
            this.minValue = minValue;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.minValue);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.minValue);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final PackedInts.Mutable values;
            private final long minValue;

            DoubleValues(PackedInts.Mutable values, long minValue) {
                super(false);
                this.values = values;
                this.minValue = minValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public double nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }

        static class LongValues
        extends DenseLongValues {
            private final PackedInts.Mutable values;
            private final long minValue;

            LongValues(PackedInts.Mutable values, long minValue) {
                super(false);
                this.values = values;
                this.minValue = minValue;
            }

            @Override
            public long nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }
    }

    public static class SingleSparse
    extends PackedArrayAtomicFieldData {
        private final PackedInts.Mutable values;
        private final long minValue;
        private final long missingValue;

        public SingleSparse(PackedInts.Mutable values, long minValue, long missingValue) {
            this.values = values;
            this.minValue = minValue;
            this.missingValue = missingValue;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = this.values.ramBytesUsed() + 16L;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.minValue, this.missingValue);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.minValue, this.missingValue);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final PackedInts.Mutable values;
            private final long minValue;
            private final long missingValue;

            DoubleValues(PackedInts.Mutable values, long minValue, long missingValue) {
                super(false);
                this.values = values;
                this.minValue = minValue;
                this.missingValue = missingValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.values.get(docId) != this.missingValue ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final PackedInts.Mutable values;
            private final long minValue;
            private final long missingValue;

            LongValues(PackedInts.Mutable values, long minValue, long missingValue) {
                super(false);
                this.values = values;
                this.minValue = minValue;
                this.missingValue = missingValue;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.values.get(docId) != this.missingValue ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return this.minValue + this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends PackedArrayAtomicFieldData {
        private final MonotonicAppendingLongBuffer values;
        private final Ordinals ordinals;

        public WithOrdinals(MonotonicAppendingLongBuffer values, Ordinals ordinals) {
            this.values = values;
            this.ordinals = ordinals;
        }

        @Override
        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 4L + this.values.ramBytesUsed() + this.ordinals.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final MonotonicAppendingLongBuffer values;

            DoubleValues(MonotonicAppendingLongBuffer values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(long ord) {
                assert (ord != -1L);
                return this.values.get(ord);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final MonotonicAppendingLongBuffer values;

            LongValues(MonotonicAppendingLongBuffer values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public long getValueByOrd(long ord) {
                assert (ord != -1L);
                return this.values.get(ord);
            }
        }
    }

    static class Empty
    extends PackedArrayAtomicFieldData {
        Empty() {
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY_LONGS;
        }
    }
}

