/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AppendingDeltaPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.breaker.MemoryCircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.PackedArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class PackedArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData<AtomicNumericFieldData> {
    private final IndexNumericFieldData.NumericType numericType;
    private final CircuitBreakerService breakerService;

    public PackedArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, IndexNumericFieldData.NumericType numericType, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Preconditions.checkNotNull(numericType);
        Preconditions.checkArgument(EnumSet.of(IndexNumericFieldData.NumericType.BYTE, IndexNumericFieldData.NumericType.SHORT, IndexNumericFieldData.NumericType.INT, IndexNumericFieldData.NumericType.LONG).contains((Object)numericType), this.getClass().getSimpleName() + " only supports integer types, not " + (Object)((Object)numericType));
        this.numericType = numericType;
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        PackedArrayAtomicFieldData data = null;
        PackedArrayEstimator estimator = new PackedArrayEstimator(this.breakerService.getBreaker(), this.getNumericType(), this.getFieldNames().fullName());
        if (terms == null) {
            data = PackedArrayAtomicFieldData.empty();
            estimator.adjustForNoTerms(data.ramBytesUsed());
            return data;
        }
        MonotonicAppendingLongBuffer values = new MonotonicAppendingLongBuffer();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);){
                BytesRef term;
                boolean indexedAsLong;
                BytesRefIterator iter = builder.buildFromTerms(termsEnum);
                assert (!this.getNumericType().isFloatingPoint());
                boolean bl = indexedAsLong = this.getNumericType().requiredBits() > 32;
                while ((term = iter.next()) != null) {
                    long value;
                    long l = value = indexedAsLong ? NumericUtils.prefixCodedToLong(term) : (long)NumericUtils.prefixCodedToInt(term);
                    assert (values.size() == 0L || value > values.get(values.size() - 1L));
                    values.add(value);
                }
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                IndexFieldData.CommonSettings.MemoryStorageFormat formatHint = IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType);
                BytesValues.WithOrdinals ordinals = build.ordinals();
                if (ordinals.isMultiValued() || formatHint == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    data = new PackedArrayAtomicFieldData.WithOrdinals(values, build);
                } else {
                    FixedBitSet docsWithValues = builder.buildDocsWithValuesSet();
                    long maxValue = 0L;
                    long minValue = 0L;
                    if (values.size() > 0L) {
                        minValue = values.get(0);
                        maxValue = values.get(values.size() - 1L);
                    }
                    float acceptableOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.25f)).floatValue();
                    int pageSize = this.fieldDataType.getSettings().getAsInt("single_value_page_size", (Integer)1024);
                    if (formatHint == null) {
                        formatHint = this.chooseStorageFormat(reader, values, build, ordinals, minValue, maxValue, acceptableOverheadRatio, pageSize);
                    }
                    this.logger.trace("single value format for field [{}] set to [{}]", new Object[]{this.getFieldNames().fullName(), formatHint});
                    switch (formatHint) {
                        case PACKED: {
                            long valuesDelta;
                            long missingValue = 0L;
                            if (docsWithValues != null) {
                                if (maxValue - minValue + 1L == values.size()) {
                                    if (minValue > Long.MIN_VALUE) {
                                        missingValue = --minValue;
                                    } else {
                                        assert (maxValue != Long.MAX_VALUE);
                                        missingValue = ++maxValue;
                                    }
                                } else {
                                    for (long i = 1L; i < values.size(); ++i) {
                                        if (values.get(i) <= values.get(i - 1L) + 1L) continue;
                                        missingValue = values.get(i - 1L) + 1L;
                                        break;
                                    }
                                }
                                missingValue -= minValue;
                            }
                            int bitsRequired = (valuesDelta = maxValue - minValue) < 0L ? 64 : PackedInts.bitsRequired(valuesDelta);
                            PackedInts.Mutable sValues = PackedInts.getMutable(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
                            if (docsWithValues != null) {
                                sValues.fill(0, sValues.size(), missingValue);
                            }
                            for (int i = 0; i < reader.maxDoc(); ++i) {
                                long ord = ordinals.getOrd(i);
                                if (ord == -1L) continue;
                                long value = values.get(ord);
                                sValues.set(i, value - minValue);
                            }
                            if (docsWithValues == null) {
                                data = new PackedArrayAtomicFieldData.Single(sValues, minValue);
                                break;
                            }
                            data = new PackedArrayAtomicFieldData.SingleSparse(sValues, minValue, missingValue);
                            break;
                        }
                        case PAGED: {
                            AppendingDeltaPackedLongBuffer dpValues = new AppendingDeltaPackedLongBuffer(reader.maxDoc() / pageSize + 1, pageSize, acceptableOverheadRatio);
                            long lastValue = 0L;
                            for (int i = 0; i < reader.maxDoc(); ++i) {
                                long ord = ordinals.getOrd(i);
                                if (ord != -1L) {
                                    lastValue = values.get(ord);
                                }
                                dpValues.add(lastValue);
                            }
                            dpValues.freeze();
                            if (docsWithValues == null) {
                                data = new PackedArrayAtomicFieldData.PagedSingle(dpValues);
                                break;
                            }
                            data = new PackedArrayAtomicFieldData.PagedSingleSparse(dpValues, docsWithValues);
                            break;
                        }
                        case ORDINALS: {
                            data = new PackedArrayAtomicFieldData.WithOrdinals(values, build);
                            break;
                        }
                        default: {
                            throw new ElasticsearchException("unknown memory format: " + (Object)((Object)formatHint));
                        }
                    }
                }
                success = true;
                PackedArrayAtomicFieldData packedArrayAtomicFieldData = data;
                return packedArrayAtomicFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.ramBytesUsed());
            }
        }
    }

    protected IndexFieldData.CommonSettings.MemoryStorageFormat chooseStorageFormat(AtomicReader reader, MonotonicAppendingLongBuffer values, Ordinals build, BytesValues.WithOrdinals ordinals, long minValue, long maxValue, float acceptableOverheadRatio, int pageSize) {
        long packedDelta = maxValue - minValue + 1L;
        int bitsRequired = packedDelta < 0L ? 64 : PackedInts.bitsRequired(packedDelta);
        PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
        long singleValuesSize = (long)formatAndBits.format.longCount(2, reader.maxDoc(), formatAndBits.bitsPerValue) * 8L;
        long ordinalsSize = build.ramBytesUsed() + values.ramBytesUsed();
        long pagedSingleValuesSize = (reader.maxDoc() / pageSize + 1) * RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int pageIndex = 0;
        long pageMinOrdinal = Long.MAX_VALUE;
        long pageMaxOrdinal = Long.MIN_VALUE;
        for (int i = 1; i < reader.maxDoc(); ++i) {
            long ordinal = ordinals.getOrd(i);
            if (ordinal != -1L) {
                pageMaxOrdinal = Math.max(ordinal, pageMaxOrdinal);
                pageMinOrdinal = Math.min(ordinal, pageMinOrdinal);
            }
            if (pageIndex == pageSize - 1) {
                pagedSingleValuesSize += this.getPageMemoryUsage(values, acceptableOverheadRatio, pageSize, pageMinOrdinal, pageMaxOrdinal);
                pageMinOrdinal = Long.MAX_VALUE;
                pageMaxOrdinal = Long.MIN_VALUE;
            }
            pageIndex = (pageIndex + 1) % pageSize;
        }
        if (pageIndex > 0) {
            ++pageIndex;
            pagedSingleValuesSize += this.getPageMemoryUsage(values, acceptableOverheadRatio, pageSize, pageMinOrdinal, pageMaxOrdinal);
        }
        IndexFieldData.CommonSettings.MemoryStorageFormat format = ordinalsSize < singleValuesSize ? (ordinalsSize < pagedSingleValuesSize ? IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS : IndexFieldData.CommonSettings.MemoryStorageFormat.PAGED) : (pagedSingleValuesSize < singleValuesSize ? IndexFieldData.CommonSettings.MemoryStorageFormat.PAGED : IndexFieldData.CommonSettings.MemoryStorageFormat.PACKED);
        return format;
    }

    private long getPageMemoryUsage(MonotonicAppendingLongBuffer values, float acceptableOverheadRatio, int pageSize, long pageMinOrdinal, long pageMaxOrdinal) {
        long pageMemorySize = 0L;
        if (pageMaxOrdinal == Long.MIN_VALUE) {
            pageMemorySize += RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            long pageMinValue = values.get(pageMinOrdinal);
            long pageMaxValue = values.get(pageMaxOrdinal);
            long pageDelta = pageMaxValue - pageMinValue;
            if (pageDelta != 0L) {
                int bitsRequired = pageDelta < 0L ? 64 : PackedInts.bitsRequired(pageDelta);
                PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(pageSize, bitsRequired, acceptableOverheadRatio);
                pageMemorySize += (long)(formatAndBits.format.longCount(2, pageSize, formatAndBits.bitsPerValue) * 8);
                pageMemorySize += 8L;
            } else {
                pageMemorySize += RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
            }
        }
        return pageMemorySize;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode) {
        return new LongValuesComparatorSource(this, missingValue, sortMode);
    }

    public class PackedArrayEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final MemoryCircuitBreaker breaker;
        private final IndexNumericFieldData.NumericType type;
        private final String fieldName;

        public PackedArrayEstimator(MemoryCircuitBreaker breaker, IndexNumericFieldData.NumericType type, String fieldName) {
            this.breaker = breaker;
            this.type = type;
            this.fieldName = fieldName;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            return Math.max(this.type.requiredBits() / 10, 4);
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.type.wrapTermsEnum(terms.iterator(null)), this.breaker, this, this.fieldName);
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }

        public void adjustForNoTerms(long actualUsed) {
            this.breaker.addWithoutBreaking(actualUsed);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private IndexNumericFieldData.NumericType numericType;

        public Builder setNumericType(IndexNumericFieldData.NumericType numericType) {
            this.numericType = numericType;
            return this;
        }

        @Override
        public IndexFieldData<AtomicNumericFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            return new PackedArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, this.numericType, breakerService);
        }
    }
}

