/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.MemoryCircuitBreaker;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildFilteredTermsEnum;
import org.elasticsearch.index.fielddata.plain.ParentChildIntersectTermsEnum;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildIndexFieldData
extends AbstractIndexFieldData<ParentChildAtomicFieldData>
implements DocumentTypeListener {
    private final NavigableSet<BytesRef> parentTypes;
    private final CircuitBreakerService breakerService;
    private final GlobalOrdinalsBuilder globalOrdinalsBuilder;
    private final Object lock = new Object();

    public ParentChildIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, MapperService mapperService, CircuitBreakerService breakerService, GlobalOrdinalsBuilder globalOrdinalsBuilder) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.parentTypes = new TreeSet<BytesRef>(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.breakerService = breakerService;
        this.globalOrdinalsBuilder = globalOrdinalsBuilder;
        for (DocumentMapper documentMapper : mapperService.docMappers(false)) {
            this.beforeCreate(documentMapper);
        }
        mapperService.addTypeListener(this);
    }

    @Override
    public boolean valuesOrdered() {
        return true;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParentChildAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        Object object = this.lock;
        synchronized (object) {
            ParentChildAtomicFieldData parentChildAtomicFieldData;
            block18: {
                boolean success = false;
                ParentChildAtomicFieldData data = null;
                ParentChildFilteredTermsEnum termsEnum = new ParentChildFilteredTermsEnum((TermsEnum)new ParentChildIntersectTermsEnum(reader, "_uid", "_parent"), this.parentTypes);
                ParentChildEstimator estimator = new ParentChildEstimator(this.breakerService.getBreaker(), termsEnum);
                TermsEnum estimatedTermsEnum = estimator.beforeLoad(null);
                ObjectObjectOpenHashMap<String, TypeBuilder> typeBuilders = ObjectObjectOpenHashMap.newInstance();
                try {
                    try {
                        DocsEnum docsEnum = null;
                        BytesRef term = estimatedTermsEnum.next();
                        while (term != null) {
                            String type = termsEnum.type();
                            TypeBuilder typeBuilder = (TypeBuilder)typeBuilders.get(type);
                            if (typeBuilder == null) {
                                typeBuilder = new TypeBuilder(acceptableTransientOverheadRatio, reader);
                                typeBuilders.put(type, typeBuilder);
                            }
                            BytesRef id = termsEnum.id();
                            long termOrd = typeBuilder.builder.nextOrdinal();
                            assert (termOrd == typeBuilder.termOrdToBytesOffset.size());
                            typeBuilder.termOrdToBytesOffset.add(typeBuilder.bytes.copyUsingLengthPrefix(id));
                            docsEnum = estimatedTermsEnum.docs(null, docsEnum, 0);
                            int docId = docsEnum.nextDoc();
                            while (docId != Integer.MAX_VALUE) {
                                typeBuilder.builder.addDoc(docId);
                                docId = docsEnum.nextDoc();
                            }
                            term = estimatedTermsEnum.next();
                        }
                        ImmutableOpenMap.Builder typeToAtomicFieldData = ImmutableOpenMap.builder(typeBuilders.size());
                        for (ObjectObjectCursor cursor : typeBuilders) {
                            long sizePointer = ((TypeBuilder)cursor.value).bytes.getPointer();
                            PagedBytes.Reader bytesReader = ((TypeBuilder)cursor.value).bytes.freeze(true);
                            Ordinals ordinals = ((TypeBuilder)cursor.value).builder.build(this.fieldDataType.getSettings());
                            typeToAtomicFieldData.put(cursor.key, new PagedBytesAtomicFieldData(bytesReader, sizePointer, ((TypeBuilder)cursor.value).termOrdToBytesOffset, ordinals));
                        }
                        data = new ParentChildAtomicFieldData(typeToAtomicFieldData.build());
                    }
                    catch (Throwable throwable) {
                        for (ObjectObjectCursor cursor : typeBuilders) {
                            ((TypeBuilder)cursor.value).builder.close();
                        }
                        throw throwable;
                    }
                    for (ObjectObjectCursor cursor : typeBuilders) {
                        ((TypeBuilder)cursor.value).builder.close();
                    }
                    success = true;
                    parentChildAtomicFieldData = data;
                    if (success) {
                        estimator.afterLoad(estimatedTermsEnum, data.ramBytesUsed());
                        break block18;
                    }
                    estimator.afterLoad(estimatedTermsEnum, 0L);
                }
                catch (Throwable throwable) {
                    if (success) {
                        estimator.afterLoad(estimatedTermsEnum, data.ramBytesUsed());
                    } else {
                        estimator.afterLoad(estimatedTermsEnum, 0L);
                    }
                    throw throwable;
                }
            }
            return parentChildAtomicFieldData;
        }
    }

    public IndexFieldData.WithOrdinals getGlobalParentChild(String type, IndexReader indexReader) {
        ParentTypesGlobalOrdinalsLoading loading = new ParentTypesGlobalOrdinalsLoading();
        ParentChildGlobalOrdinalsIndexFieldData holder = (ParentChildGlobalOrdinalsIndexFieldData)loading.loadGlobal(indexReader);
        return holder.type(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeCreate(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active() && this.parentTypes.add(new BytesRef(parentFieldMapper.type()))) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRemove(DocumentMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (parentFieldMapper.active()) {
                this.parentTypes.remove(new BytesRef(parentFieldMapper.type()));
            }
        }
    }

    private final class ParentChildGlobalOrdinalsIndexFieldData
    extends GlobalOrdinalsIndexFieldData {
        private final ImmutableOpenMap<String, IndexFieldData.WithOrdinals> typeGlobalOrdinals;

        private ParentChildGlobalOrdinalsIndexFieldData(ImmutableOpenMap<String, IndexFieldData.WithOrdinals> typeGlobalOrdinals, long memorySizeInBytes) {
            super(ParentChildIndexFieldData.this.index(), ParentChildIndexFieldData.this.indexSettings, ParentChildIndexFieldData.this.getFieldNames(), ParentChildIndexFieldData.this.getFieldDataType(), memorySizeInBytes);
            this.typeGlobalOrdinals = typeGlobalOrdinals;
        }

        @Override
        public AtomicFieldData.WithOrdinals load(AtomicReaderContext context) {
            throw new ElasticsearchIllegalStateException("Can't use directly");
        }

        public IndexFieldData.WithOrdinals type(String type) {
            return this.typeGlobalOrdinals.get(type);
        }
    }

    private class ParentTypesGlobalOrdinalsLoading
    implements IndexFieldData.WithOrdinals {
        @Override
        public AtomicFieldData.WithOrdinals load(AtomicReaderContext context) {
            throw new ElasticsearchIllegalStateException("Shouldn't be invoked");
        }

        @Override
        public AtomicFieldData.WithOrdinals loadDirect(AtomicReaderContext context) {
            throw new ElasticsearchIllegalStateException("Shouldn't be invoked");
        }

        @Override
        public IndexFieldData.WithOrdinals loadGlobal(IndexReader indexReader) {
            if (indexReader.leaves().size() <= 1) {
                ImmutableOpenMap.Builder<String, PerType> globalIfdPerType = ImmutableOpenMap.builder();
                for (BytesRef parentType : ParentChildIndexFieldData.this.parentTypes) {
                    PerType perType = new PerType(parentType.utf8ToString());
                    globalIfdPerType.put(perType.type, perType);
                }
                return new ParentChildGlobalOrdinalsIndexFieldData(globalIfdPerType.build(), 0L);
            }
            try {
                return ParentChildIndexFieldData.this.cache.load(indexReader, this);
            }
            catch (Throwable e) {
                if (e instanceof ElasticsearchException) {
                    throw (ElasticsearchException)e;
                }
                throw new ElasticsearchException(e.getMessage(), e);
            }
        }

        @Override
        public IndexFieldData.WithOrdinals localGlobalDirect(IndexReader indexReader) throws Exception {
            ImmutableOpenMap.Builder<String, GlobalOrdinalsIndexFieldData> globalIfdPerType = ImmutableOpenMap.builder();
            long memorySizeInBytes = 0L;
            for (BytesRef parentType : ParentChildIndexFieldData.this.parentTypes) {
                PerType perType = new PerType(parentType.utf8ToString());
                GlobalOrdinalsIndexFieldData globalIfd = (GlobalOrdinalsIndexFieldData)ParentChildIndexFieldData.this.globalOrdinalsBuilder.build(indexReader, perType, ParentChildIndexFieldData.this.indexSettings, ParentChildIndexFieldData.this.breakerService);
                globalIfdPerType.put(perType.type, globalIfd);
                memorySizeInBytes += globalIfd.ramBytesUsed();
            }
            return new ParentChildGlobalOrdinalsIndexFieldData(globalIfdPerType.build(), memorySizeInBytes);
        }

        @Override
        public FieldMapper.Names getFieldNames() {
            return ParentChildIndexFieldData.this.getFieldNames();
        }

        @Override
        public FieldDataType getFieldDataType() {
            return ParentChildIndexFieldData.this.getFieldDataType();
        }

        @Override
        public boolean valuesOrdered() {
            return ParentChildIndexFieldData.this.valuesOrdered();
        }

        @Override
        public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode) {
            throw new UnsupportedOperationException("Sort not supported on PerParentTypeGlobalOrdinals...");
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(IndexReader reader) {
        }

        @Override
        public Index index() {
            return ParentChildIndexFieldData.this.index();
        }

        private final class PerType
        extends ParentTypesGlobalOrdinalsLoading {
            private final String type;

            public PerType(String type) {
                this.type = type;
            }

            @Override
            public AtomicFieldData.WithOrdinals load(AtomicReaderContext context) {
                return this.loadDirect(context);
            }

            @Override
            public AtomicFieldData.WithOrdinals loadDirect(AtomicReaderContext context) {
                ParentChildAtomicFieldData parentChildAtomicFieldData = (ParentChildAtomicFieldData)ParentChildIndexFieldData.this.load(context);
                AtomicFieldData.WithOrdinals typeAfd = parentChildAtomicFieldData.getAtomicFieldData(this.type);
                if (typeAfd != null) {
                    return typeAfd;
                }
                return AtomicFieldData.WithOrdinals.EMPTY;
            }

            @Override
            public IndexFieldData.WithOrdinals loadGlobal(IndexReader indexReader) {
                return this;
            }

            @Override
            public IndexFieldData.WithOrdinals localGlobalDirect(IndexReader indexReader) throws Exception {
                return this;
            }
        }
    }

    public class ParentChildEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final MemoryCircuitBreaker breaker;
        private final TermsEnum filteredEnum;

        public ParentChildEstimator(MemoryCircuitBreaker breaker, TermsEnum filteredEnum) {
            this.breaker = breaker;
            this.filteredEnum = filteredEnum;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            return 2 * term.length;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.filteredEnum, this.breaker, this, "parent/child id cache");
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            return new ParentChildIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, mapperService, breakerService, globalOrdinalBuilder);
        }
    }

    class TypeBuilder {
        final PagedBytes bytes = new PagedBytes(15);
        final MonotonicAppendingLongBuffer termOrdToBytesOffset = new MonotonicAppendingLongBuffer();
        final OrdinalsBuilder builder;

        TypeBuilder(float acceptableTransientOverheadRatio, AtomicReader reader) throws IOException {
            this.builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        }
    }
}

