/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;

public class SingleFieldsVisitor
extends FieldsVisitor {
    private String field;

    public SingleFieldsVisitor(String field) {
        this.field = field;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (fieldInfo.name.equals(this.field)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (fieldInfo.name.equals("_uid") && ("_type".equals(this.field) || "_id".equals(this.field))) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void reset(String field) {
        this.field = field;
        super.reset();
    }

    public void postProcess(FieldMapper mapper) {
        if (this.uid != null) {
            switch (this.field) {
                case "_uid": {
                    this.addValue(this.field, this.uid.toString());
                }
                case "_id": {
                    this.addValue(this.field, this.uid.id());
                }
                case "_type": {
                    this.addValue(this.field, this.uid.type());
                }
            }
        }
        if (this.fieldsValues == null) {
            return;
        }
        List fieldValues = (List)this.fieldsValues.get(mapper.names().indexName());
        if (fieldValues == null) {
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            fieldValues.set(i, mapper.valueForSearch(fieldValues.get(i)));
        }
    }
}

