/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsTranslog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final ThreadPool threadPool;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final IndexService indexService;
    private final InternalIndexShard indexShard;
    private final TimeValue waitForMappingUpdatePostRecovery;
    private final RecoveryState recoveryState = new RecoveryState();
    private volatile ScheduledFuture flushScheduler;
    private final TimeValue syncInterval;

    @Inject
    public LocalIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, MappingUpdatedAction mappingUpdatedAction, IndexService indexService, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.indexService = indexService;
        this.indexShard = (InternalIndexShard)indexShard;
        this.waitForMappingUpdatePostRecovery = this.componentSettings.getAsTime("wait_for_mapping_update_post_recovery", TimeValue.timeValueSeconds(30L));
        this.syncInterval = this.componentSettings.getAsTime("sync", TimeValue.timeValueSeconds(5L));
        if (this.syncInterval.millis() > 0L) {
            this.indexShard.translog().syncOnEachOperation(false);
            this.flushScheduler = threadPool.schedule(this.syncInterval, "same", new Sync());
        } else if (this.syncInterval.millis() == 0L) {
            this.flushScheduler = null;
            this.indexShard.translog().syncOnEachOperation(true);
        } else {
            this.flushScheduler = null;
        }
    }

    public String toString() {
        return "local";
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardGatewayRecoveryException {
        recoveryState.getIndex().startTime(System.currentTimeMillis());
        recoveryState.setStage(RecoveryState.Stage.INDEX);
        long version = -1L;
        long translogId = -1L;
        this.indexShard.store().incRef();
        try {
            try {
                SegmentInfos si;
                block42: {
                    this.indexShard.store().failIfCorrupted();
                    si = null;
                    try {
                        si = Lucene.readSegmentInfos(this.indexShard.store().directory());
                    }
                    catch (Throwable e) {
                        String files = "_unknown_";
                        try {
                            files = Arrays.toString(this.indexShard.store().directory().listAll());
                        }
                        catch (Throwable e1) {
                            files = files + " (failure=" + ExceptionsHelper.detailedMessage(e1) + ")";
                        }
                        if (!indexShouldExists || !this.indexShard.store().indexStore().persistent()) break block42;
                        throw new IndexShardGatewayRecoveryException(this.shardId(), "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                    }
                }
                if (si != null) {
                    if (indexShouldExists) {
                        version = si.getVersion();
                        translogId = si.getUserData().containsKey("translog_id") ? Long.parseLong(si.getUserData().get("translog_id")) : version;
                        this.logger.trace("using existing shard data, translog id [{}]", translogId);
                    } else {
                        this.logger.trace("cleaning existing shard, shouldn't exists", new Object[0]);
                        IndexWriter writer = new IndexWriter(this.indexShard.store().directory(), new IndexWriterConfig(Lucene.VERSION, Lucene.STANDARD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                        writer.close();
                    }
                }
            }
            catch (Throwable e) {
                throw new IndexShardGatewayRecoveryException(this.shardId(), "failed to fetch index version after copying it over", e);
            }
            recoveryState.getIndex().updateVersion(version);
            recoveryState.getIndex().time(System.currentTimeMillis() - recoveryState.getIndex().startTime());
            try {
                int numberOfFiles = 0;
                long totalSizeInBytes = 0L;
                for (String name : this.indexShard.store().directory().listAll()) {
                    ++numberOfFiles;
                    long length = this.indexShard.store().directory().fileLength(name);
                    totalSizeInBytes += length;
                    recoveryState.getIndex().addFileDetail(name, length, length);
                }
                RecoveryState.Index index = recoveryState.getIndex();
                index.totalFileCount(numberOfFiles);
                index.totalByteCount(totalSizeInBytes);
                index.reusedFileCount(numberOfFiles);
                index.reusedByteCount(totalSizeInBytes);
                index.recoveredFileCount(numberOfFiles);
                index.recoveredByteCount(totalSizeInBytes);
            }
            catch (Exception e) {
                // empty catch block
            }
            recoveryState.getStart().startTime(System.currentTimeMillis());
            recoveryState.setStage(RecoveryState.Stage.START);
            if (translogId == -1L) {
                this.indexShard.postRecovery("post recovery from gateway, no translog");
                recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
                recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
                return;
            }
            FsTranslog translog = (FsTranslog)this.indexShard.translog();
            String translogName = "translog-" + translogId;
            String recoverTranslogName = translogName + ".recovering";
            File recoveringTranslogFile = null;
            block30: for (File translogLocation : translog.locations()) {
                File tmpRecoveringFile = new File(translogLocation, recoverTranslogName);
                if (!tmpRecoveringFile.exists()) {
                    File tmpTranslogFile = new File(translogLocation, translogName);
                    if (!tmpTranslogFile.exists()) continue;
                    for (int i = 0; i < 3; ++i) {
                        if (!tmpTranslogFile.renameTo(tmpRecoveringFile)) continue;
                        recoveringTranslogFile = tmpRecoveringFile;
                        continue block30;
                    }
                    continue;
                }
                recoveringTranslogFile = tmpRecoveringFile;
                break;
            }
            if (recoveringTranslogFile == null || !recoveringTranslogFile.exists()) {
                this.indexShard.postRecovery("post recovery from gateway, no translog");
                recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
                recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
                return;
            }
            this.indexShard.performRecoveryPrepareForTranslog();
            recoveryState.getStart().time(System.currentTimeMillis() - recoveryState.getStart().startTime());
            recoveryState.getStart().checkIndexTime(this.indexShard.checkIndexTook());
            recoveryState.getTranslog().startTime(System.currentTimeMillis());
            recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            FileInputStream fs = null;
            HashSet<String> typesToUpdate = Sets.newHashSet();
            try {
                fs = new FileInputStream(recoveringTranslogFile);
                InputStreamStreamInput si = new InputStreamStreamInput(fs);
                while (true) {
                    Translog.Operation operation;
                    try {
                        int opSize = si.readInt();
                        operation = TranslogStreams.readTranslogOperation(si);
                    }
                    catch (EOFException e) {
                        break;
                    }
                    catch (IOException e) {
                        break;
                    }
                    try {
                        Engine.IndexingOperation potentialIndexOperation = this.indexShard.performRecoveryOperation(operation);
                        if (potentialIndexOperation != null && potentialIndexOperation.parsedDoc().mappingsModified() && !typesToUpdate.contains(potentialIndexOperation.docMapper().type())) {
                            typesToUpdate.add(potentialIndexOperation.docMapper().type());
                        }
                        recoveryState.getTranslog().addTranslogOperations(1);
                        continue;
                    }
                    catch (ElasticsearchException e) {
                        if (e.status() == RestStatus.BAD_REQUEST) {
                            this.logger.info("ignoring recovery of a corrupt translog entry", e, new Object[0]);
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.indexShard.translog().closeWithDelete();
                throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover shard", e);
            }
            finally {
                try {
                    fs.close();
                }
                catch (IOException e) {}
            }
            this.indexShard.performRecoveryFinalization(true);
            recoveringTranslogFile.delete();
            for (final String type : typesToUpdate) {
                final CountDownLatch latch = new CountDownLatch(1);
                this.mappingUpdatedAction.updateMappingOnMaster(this.indexService.index().name(), this.indexService.mapperService().documentMapper(type), this.indexService.indexUUID(), new MappingUpdatedAction.MappingUpdateListener(){

                    @Override
                    public void onMappingUpdate() {
                        latch.countDown();
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        latch.countDown();
                        LocalIndexShardGateway.this.logger.debug("failed to send mapping update post recovery to master for [{}]", t, type);
                    }
                });
                try {
                    boolean waited = latch.await(this.waitForMappingUpdatePostRecovery.millis(), TimeUnit.MILLISECONDS);
                    if (waited) continue;
                    this.logger.debug("waited for mapping update on master for [{}], yet timed out", new Object[0]);
                }
                catch (InterruptedException e) {
                    this.logger.debug("interrupted while waiting for mapping update", new Object[0]);
                }
            }
        }
        finally {
            this.indexShard.store().decRef();
        }
        recoveryState.getTranslog().time(System.currentTimeMillis() - recoveryState.getTranslog().startTime());
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    public void close() {
        if (this.flushScheduler != null) {
            this.flushScheduler.cancel(false);
        }
    }

    class Sync
    implements Runnable {
        Sync() {
        }

        @Override
        public void run() {
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.STARTED && LocalIndexShardGateway.this.indexShard.translog().syncNeeded()) {
                LocalIndexShardGateway.this.threadPool.executor("flush").execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                LocalIndexShardGateway.this.indexShard.translog().sync();
                            }
                            catch (Exception e) {
                                if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.STARTED) break block3;
                                LocalIndexShardGateway.this.logger.warn("failed to sync translog", e, new Object[0]);
                            }
                        }
                        if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.CLOSED) {
                            LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", Sync.this);
                        }
                    }
                });
            } else {
                LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", this);
            }
        }
    }
}

