/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.common.lucene.BytesRefs;

public final class Uid {
    public static final char DELIMITER = '#';
    public static final byte DELIMITER_BYTE = 35;
    public static final BytesRef DELIMITER_BYTES = new BytesRef(new byte[]{35});
    private final String type;
    private final String id;

    public Uid(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uid uid = (Uid)o;
        if (this.id != null ? !this.id.equals(uid.id) : uid.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(uid.type) : uid.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Uid.createUid(this.type, this.id);
    }

    public BytesRef toBytesRef() {
        return Uid.createUidAsBytes(this.type, this.id);
    }

    public static BytesRef typePrefixAsBytes(BytesRef type) {
        BytesRef bytesRef = new BytesRef(type.length + 1);
        bytesRef.append(type);
        bytesRef.append(DELIMITER_BYTES);
        return bytesRef;
    }

    public static Uid createUid(String uid) {
        int delimiterIndex = uid.indexOf(35);
        return new Uid(uid.substring(0, delimiterIndex), uid.substring(delimiterIndex + 1));
    }

    public static BytesRef[] createUids(List<MultiGetRequest.Item> items) {
        BytesRef[] uids = new BytesRef[items.size()];
        int idx = 0;
        for (MultiGetRequest.Item item : items) {
            uids[idx++] = Uid.createUidAsBytes(item);
        }
        return uids;
    }

    public static BytesRef createUidAsBytes(String type, String id) {
        return Uid.createUidAsBytes(new BytesRef(type), new BytesRef(id));
    }

    public static BytesRef createUidAsBytes(String type, BytesRef id) {
        return Uid.createUidAsBytes(new BytesRef(type), id);
    }

    public static BytesRef createUidAsBytes(MultiGetRequest.Item item) {
        return Uid.createUidAsBytes(item.type(), item.id());
    }

    public static BytesRef createUidAsBytes(BytesRef type, BytesRef id) {
        BytesRef ref = new BytesRef(type.length + 1 + id.length);
        System.arraycopy(type.bytes, type.offset, ref.bytes, 0, type.length);
        ref.offset = type.length;
        ref.bytes[ref.offset++] = 35;
        System.arraycopy(id.bytes, id.offset, ref.bytes, ref.offset, id.length);
        ref.offset = 0;
        ref.length = ref.bytes.length;
        return ref;
    }

    public static void createUidAsBytes(BytesRef type, BytesRef id, BytesRef spare) {
        spare.copyBytes(type);
        spare.append(DELIMITER_BYTES);
        spare.append(id);
    }

    public static BytesRef[] createTypeUids(Collection<String> types, Object ids) {
        return Uid.createTypeUids(types, Collections.singletonList(ids));
    }

    public static BytesRef[] createTypeUids(Collection<String> types, List<? extends Object> ids) {
        int numIds = ids.size();
        BytesRef[] uids = new BytesRef[types.size() * ids.size()];
        BytesRef typeBytes = new BytesRef();
        BytesRef idBytes = new BytesRef();
        int index = 0;
        for (String type : types) {
            UnicodeUtil.UTF16toUTF8(type, 0, type.length(), typeBytes);
            int i = 0;
            while (i < numIds) {
                uids[index] = Uid.createUidAsBytes(typeBytes, BytesRefs.toBytesRef(ids.get(i), idBytes));
                ++i;
                ++index;
            }
        }
        return uids;
    }

    public static String createUid(String type, String id) {
        return Uid.createUid(new StringBuilder(), type, id);
    }

    public static String createUid(StringBuilder sb, String type, String id) {
        return sb.append(type).append('#').append(id).toString();
    }

    public static boolean hasDelimiter(BytesRef uid) {
        int limit = uid.offset + uid.length;
        for (int i = uid.offset; i < limit; ++i) {
            if (uid.bytes[i] != 35) continue;
            return true;
        }
        return false;
    }

    public static BytesRef[] splitUidIntoTypeAndId(BytesRef uid) {
        int loc = -1;
        int limit = uid.offset + uid.length;
        for (int i = uid.offset; i < limit; ++i) {
            if (uid.bytes[i] != 35) continue;
            loc = i;
            break;
        }
        if (loc == -1) {
            return null;
        }
        int idStart = loc + 1;
        return new BytesRef[]{new BytesRef(uid.bytes, uid.offset, loc - uid.offset), new BytesRef(uid.bytes, idStart, limit - idStart)};
    }
}

