/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class BooleanFieldMapper
extends AbstractFieldMapper<Boolean> {
    public static final String CONTENT_TYPE = "boolean";
    private Boolean nullValue;

    protected BooleanFieldMapper(FieldMapper.Names names, float boost, FieldType fieldType, Boolean nullValue, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, boost, fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.nullValue = nullValue;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Boolean value(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        String sValue = value.toString();
        if (sValue.length() == 0) {
            return Boolean.FALSE;
        }
        if (sValue.length() == 1 && sValue.charAt(0) == 'F') {
            return Boolean.FALSE;
        }
        if (Booleans.parseBoolean(sValue, false)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object valueForSearch(Object value) {
        return this.value(value);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        if (value == null) {
            return Values.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Values.TRUE : Values.FALSE;
        }
        String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
        if (sValue.length() == 0) {
            return Values.FALSE;
        }
        if (sValue.length() == 1 && sValue.charAt(0) == 'F') {
            return Values.FALSE;
        }
        if (Booleans.parseBoolean(sValue, false)) {
            return Values.TRUE;
        }
        return Values.FALSE;
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return new TermFilter(this.names().createIndexNameTerm(this.nullValue != false ? Values.TRUE : Values.FALSE));
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.fieldType().indexed() && !this.fieldType().stored()) {
            return;
        }
        Boolean value = context.parseExternalValue(Boolean.class);
        if (value == null) {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    value = this.nullValue;
                }
            } else {
                value = context.parser().booleanValue();
            }
        }
        if (value == null) {
            return;
        }
        fields.add(new Field(this.names.indexName(), value != false ? "T" : "F", this.fieldType));
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((BooleanFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", (Object)this.nullValue);
        }
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.booleanField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeBooleanValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BooleanFieldMapper> {
        private Boolean nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder nullValue(boolean nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Builder tokenized(boolean tokenized) {
            if (tokenized) {
                throw new ElasticsearchIllegalArgumentException("bool field can't be tokenized");
            }
            return (Builder)super.tokenized(tokenized);
        }

        @Override
        public BooleanFieldMapper build(Mapper.BuilderContext context) {
            return new BooleanFieldMapper(this.buildNames(context), this.boost, this.fieldType, this.nullValue, this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef("T");
        public static final BytesRef FALSE = new BytesRef("F");
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final Boolean NULL_VALUE;

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

