/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class FieldNamesFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";
    private final FieldType defaultFieldType;

    private static FieldType defaultFieldType(Settings indexSettings) {
        return indexSettings != null && Version.indexCreated(indexSettings).onOrAfter(Version.V_1_3_0) ? Defaults.FIELD_TYPE : Defaults.FIELD_TYPE_PRE_1_3_0;
    }

    public FieldNamesFieldMapper(Settings indexSettings) {
        this("_field_names", "_field_names", indexSettings);
    }

    protected FieldNamesFieldMapper(String name, String indexName, Settings indexSettings) {
        this(name, indexName, 1.0f, new FieldType(FieldNamesFieldMapper.defaultFieldType(indexSettings)), null, null, null, indexSettings);
    }

    public FieldNamesFieldMapper(String name, String indexName, float boost, FieldType fieldType, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsProvider, docValuesProvider, null, null, fieldDataSettings, indexSettings);
        this.defaultFieldType = FieldNamesFieldMapper.defaultFieldType(indexSettings);
    }

    @Override
    public FieldType defaultFieldType() {
        return this.defaultFieldType;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new UnmodifiableIterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    @Override
                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }
                };
            }
        };
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!(this.fieldType.indexed() || this.fieldType.stored() || this.hasDocValues())) {
            return;
        }
        for (ParseContext.Document document : context.docs()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (IndexableField field : document.getFields()) {
                paths.add(field.name());
            }
            for (String path : paths) {
                for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                    if (this.fieldType.indexed() || this.fieldType.stored()) {
                        document.add(new Field(this.names().indexName(), fieldName, this.fieldType));
                    }
                    if (!this.hasDocValues()) continue;
                    document.add(new SortedSetDocValuesField(this.names().indexName(), new BytesRef(fieldName)));
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder json = XContentFactory.jsonBuilder();
        super.toXContent(json, params);
        if (json.string().equals("\"_field_names\"{\"type\":\"_field_names\"}")) {
            return builder;
        }
        return super.toXContent(builder, params);
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_1_3_0)) {
                Builder builder = MapperBuilders.fieldNames();
                TypeParsers.parseField(builder, builder.name, node, parserContext);
                return builder;
            }
            throw new ElasticsearchIllegalArgumentException("type=_field_names is not supported on indices created before version 1.3.0 is your cluster running multiple datanode versions?");
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, FieldNamesFieldMapper> {
        private boolean indexIsExplicit;

        public Builder() {
            super("_field_names", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_field_names";
        }

        @Override
        public Builder index(boolean index) {
            this.indexIsExplicit = true;
            return (Builder)super.index(index);
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            if ((context.indexCreatedVersion() == null || context.indexCreatedVersion().before(Version.V_1_3_0)) && !this.indexIsExplicit) {
                this.fieldType.setIndexed(false);
            }
            return new FieldNamesFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.postingsProvider, this.docValuesProvider, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_field_names";
        public static final String INDEX_NAME = "_field_names";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final FieldType FIELD_TYPE_PRE_1_3_0;

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
            FIELD_TYPE_PRE_1_3_0 = new FieldType(FIELD_TYPE);
            FIELD_TYPE_PRE_1_3_0.setIndexed(false);
            FIELD_TYPE_PRE_1_3_0.freeze();
        }
    }
}

