/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.RegexpFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;

public class IdFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";
    private final String path;

    public IdFieldMapper() {
        this(new FieldType(Defaults.FIELD_TYPE));
    }

    public IdFieldMapper(FieldType fieldType) {
        this("_id", "_id", fieldType, null);
    }

    protected IdFieldMapper(String name, String indexName, FieldType fieldType, Boolean docValues) {
        this(name, indexName, 1.0f, fieldType, docValues, Defaults.PATH, null, null, null, ImmutableSettings.EMPTY);
    }

    protected IdFieldMapper(String name, String indexName, float boost, FieldType fieldType, Boolean docValues, String path, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, docValues, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsProvider, docValuesProvider, null, null, fieldDataSettings, indexSettings);
        this.path = path;
    }

    public String path() {
        return this.path;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termQuery(value, context);
        }
        return new ConstantScoreQuery(this.termFilter(value, context));
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termFilter(value, context);
        }
        return new TermsFilter("_uid", Uid.createTypeUids(context.queryTypes(), value));
    }

    @Override
    public Filter termsFilter(List values, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.termsFilter(values, context);
        }
        return new TermsFilter("_uid", Uid.createTypeUids(context.queryTypes(), values));
    }

    @Override
    public Query prefixQuery(Object value, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.prefixQuery(value, method, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            PrefixQuery prefixQuery = new PrefixQuery(new Term("_uid", Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value))));
            if (method != null) {
                prefixQuery.setRewriteMethod(method);
            }
            return prefixQuery;
        }
        BooleanQuery query = new BooleanQuery();
        for (String queryType : queryTypes) {
            PrefixQuery prefixQuery = new PrefixQuery(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value))));
            if (method != null) {
                prefixQuery.setRewriteMethod(method);
            }
            query.add(prefixQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public Filter prefixFilter(Object value, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.prefixFilter(value, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            return new PrefixFilter(new Term("_uid", Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value))));
        }
        XBooleanFilter filter = new XBooleanFilter();
        for (String queryType : queryTypes) {
            filter.add(new PrefixFilter(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value)))), BooleanClause.Occur.SHOULD);
        }
        return filter;
    }

    @Override
    public Query regexpQuery(Object value, int flags, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.regexpQuery(value, flags, method, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term("_uid", Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value))), flags);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            return regexpQuery;
        }
        BooleanQuery query = new BooleanQuery();
        for (String queryType : queryTypes) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value))), flags);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query.add(regexpQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public Filter regexpFilter(Object value, int flags, @Nullable QueryParseContext context) {
        if (this.fieldType.indexed() || context == null) {
            return super.regexpFilter(value, flags, context);
        }
        Collection<String> queryTypes = context.queryTypes();
        if (queryTypes.size() == 1) {
            return new RegexpFilter(new Term("_uid", Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value))), flags);
        }
        XBooleanFilter filter = new XBooleanFilter();
        for (String queryType : queryTypes) {
            filter.add(new RegexpFilter(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value))), flags), BooleanClause.Occur.SHOULD);
        }
        return filter;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentName() != null && parser.currentName().equals("_id") && parser.currentToken().isValue()) {
            String id = parser.text();
            if (context.id() != null && !context.id().equals(id)) {
                throw new MapperParsingException("Provided id [" + context.id() + "] does not match the content one [" + id + "]");
            }
            context.id(id);
        }
        if (this.fieldType.indexed() || this.fieldType.stored()) {
            fields.add(new Field(this.names.indexName(), context.id(), this.fieldType));
        }
        if (this.hasDocValues()) {
            fields.add(new BinaryDocValuesField(this.names.indexName(), new BytesRef(context.id())));
        }
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String format;
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!(includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored() || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed() || this.path != Defaults.PATH || this.customFieldDataSettings != null || this.postingsFormat != null && !this.postingsFormat.name().equals(this.defaultPostingFormat()) || this.docValuesFormat != null && !this.docValuesFormat.name().equals(this.defaultDocValuesFormat()))) {
            return builder;
        }
        builder.startObject("_id");
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed()) {
            builder.field("index", IdFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        if (includeDefaults || this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        if (this.postingsFormat != null) {
            if (includeDefaults || !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
                builder.field("postings_format", this.postingsFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultPostingFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("postings_format", format);
        }
        if (this.docValuesFormat != null) {
            if (includeDefaults || !this.docValuesFormat.name().equals(this.defaultDocValuesFormat())) {
                builder.field("doc_values_format", this.docValuesFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultDocValuesFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("doc_values_format", format);
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.id();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("path")) continue;
                builder.path(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, IdFieldMapper> {
        private String path = Defaults.PATH;

        public Builder() {
            super("_id", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_id";
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        @Override
        public IdFieldMapper build(Mapper.BuilderContext context) {
            return new IdFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.docValues, this.path, this.postingsProvider, this.docValuesProvider, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_id";
        public static final String INDEX_NAME = "_id";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final String PATH;

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
            PATH = null;
        }
    }
}

