/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TrackingConcurrentMergeScheduler;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public class ConcurrentMergeSchedulerProvider
extends MergeSchedulerProvider {
    private final IndexSettingsService indexSettingsService;
    private final ApplySettings applySettings = new ApplySettings();
    private static final String MAX_THREAD_COUNT_KEY = "max_thread_count";
    private static final String MAX_MERGE_COUNT_KEY = "max_merge_count";
    public static final String MAX_THREAD_COUNT = "index.merge.scheduler.max_thread_count";
    public static final String MAX_MERGE_COUNT = "index.merge.scheduler.max_merge_count";
    private volatile int maxThreadCount;
    private volatile int maxMergeCount;
    private Set<CustomConcurrentMergeScheduler> schedulers = new CopyOnWriteArraySet<CustomConcurrentMergeScheduler>();

    @Inject
    public ConcurrentMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService) {
        super(shardId, indexSettings, threadPool);
        this.indexSettingsService = indexSettingsService;
        this.maxThreadCount = this.componentSettings.getAsInt(MAX_THREAD_COUNT_KEY, (Integer)Math.max(1, Math.min(3, EsExecutors.boundedNumberOfProcessors(indexSettings) / 2)));
        this.maxMergeCount = this.componentSettings.getAsInt(MAX_MERGE_COUNT_KEY, (Integer)(this.maxThreadCount + 2));
        this.logger.debug("using [concurrent] merge scheduler with max_thread_count[{}], max_merge_count[{}]", this.maxThreadCount, this.maxMergeCount);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public MergeScheduler buildMergeScheduler() {
        CustomConcurrentMergeScheduler concurrentMergeScheduler = new CustomConcurrentMergeScheduler(this.logger, this.shardId, this);
        concurrentMergeScheduler.setMaxMergesAndThreads(this.maxMergeCount + 1, this.maxThreadCount);
        this.schedulers.add(concurrentMergeScheduler);
        return concurrentMergeScheduler;
    }

    @Override
    public MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        for (CustomConcurrentMergeScheduler scheduler : this.schedulers) {
            mergeStats.add(scheduler.totalMerges(), scheduler.totalMergeTime(), scheduler.totalMergeNumDocs(), scheduler.totalMergeSizeInBytes(), scheduler.currentMerges(), scheduler.currentMergesNumDocs(), scheduler.currentMergesSizeInBytes());
        }
        return mergeStats;
    }

    @Override
    public Set<OnGoingMerge> onGoingMerges() {
        Iterator<CustomConcurrentMergeScheduler> i$ = this.schedulers.iterator();
        if (i$.hasNext()) {
            CustomConcurrentMergeScheduler scheduler = i$.next();
            return scheduler.onGoingMerges();
        }
        return ImmutableSet.of();
    }

    @Override
    public void close() {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    @Override
    public int getMaxMerges() {
        return this.maxMergeCount;
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int maxMergeCount;
            int maxThreadCount = settings.getAsInt(ConcurrentMergeSchedulerProvider.MAX_THREAD_COUNT, (Integer)ConcurrentMergeSchedulerProvider.this.maxThreadCount);
            if (maxThreadCount != ConcurrentMergeSchedulerProvider.this.maxThreadCount) {
                ConcurrentMergeSchedulerProvider.this.logger.info("updating [max_thread_count] from [{}] to [{}]", ConcurrentMergeSchedulerProvider.this.maxThreadCount, maxThreadCount);
                ConcurrentMergeSchedulerProvider.this.maxThreadCount = maxThreadCount;
                for (CustomConcurrentMergeScheduler scheduler : ConcurrentMergeSchedulerProvider.this.schedulers) {
                    scheduler.setMaxMergesAndThreads(ConcurrentMergeSchedulerProvider.this.maxMergeCount, maxThreadCount);
                }
            }
            if ((maxMergeCount = settings.getAsInt(ConcurrentMergeSchedulerProvider.MAX_MERGE_COUNT, (Integer)ConcurrentMergeSchedulerProvider.this.maxMergeCount).intValue()) != ConcurrentMergeSchedulerProvider.this.maxMergeCount) {
                ConcurrentMergeSchedulerProvider.this.logger.info("updating [max_merge_count] from [{}] to [{}]", ConcurrentMergeSchedulerProvider.this.maxMergeCount, maxMergeCount);
                ConcurrentMergeSchedulerProvider.this.maxMergeCount = maxMergeCount;
                for (CustomConcurrentMergeScheduler scheduler : ConcurrentMergeSchedulerProvider.this.schedulers) {
                    scheduler.setMaxMergesAndThreads(maxMergeCount, ConcurrentMergeSchedulerProvider.this.maxThreadCount);
                }
            }
        }
    }

    public static class CustomConcurrentMergeScheduler
    extends TrackingConcurrentMergeScheduler {
        private final ShardId shardId;
        private final ConcurrentMergeSchedulerProvider provider;

        private CustomConcurrentMergeScheduler(ESLogger logger, ShardId shardId, ConcurrentMergeSchedulerProvider provider) {
            super(logger);
            this.shardId = shardId;
            this.provider = provider;
        }

        @Override
        protected ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
            ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(writer, merge);
            thread.setName(EsExecutors.threadName(this.provider.indexSettings(), "[" + this.shardId.index().name() + "][" + this.shardId.id() + "]: " + thread.getName()));
            return thread;
        }

        @Override
        protected void handleMergeException(Throwable exc) {
            this.logger.warn("failed to merge", exc, new Object[0]);
            this.provider.failedMerge(new MergePolicy.MergeException(exc, this.dir));
            super.handleMergeException(exc);
        }

        @Override
        public void close() {
            super.close();
            this.provider.schedulers.remove(this);
        }

        @Override
        protected void beforeMerge(OnGoingMerge merge) {
            super.beforeMerge(merge);
            this.provider.beforeMerge(merge);
        }

        @Override
        protected void afterMerge(OnGoingMerge merge) {
            super.afterMerge(merge);
            this.provider.afterMerge(merge);
        }
    }
}

