/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.ObjectArrays;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.morelikethis.MoreLikeThisFetchService;

public class MoreLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "mlt";
    private MoreLikeThisFetchService fetchService = null;

    @Inject(optional=true)
    public void setFetchService(@Nullable MoreLikeThisFetchService fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this", "moreLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        Analyzer analyzer = null;
        AbstractList moreLikeFields = null;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        boolean include = false;
        String currentFieldName = null;
        ArrayList<MultiGetRequest.Item> items = new ArrayList<MultiGetRequest.Item>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (Fields.LIKE_TEXT.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if (Fields.MIN_TERM_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if (Fields.MAX_QUERY_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if (Fields.MIN_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if (Fields.MAX_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if (Fields.MIN_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if (Fields.MAX_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if (Fields.BOOST_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    float boostFactor = parser.floatValue();
                    if (boostFactor == 0.0f) continue;
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(boostFactor);
                    continue;
                }
                if (Fields.PERCENT_TERMS_TO_MATCH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setPercentTermsToMatch(parser.floatValue());
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                if (Fields.FAIL_ON_UNSUPPORTED_FIELD.match(currentFieldName, parseContext.parseFlags())) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if (Fields.INCLUDE.match(currentFieldName, parseContext.parseFlags())) {
                    include = parser.booleanValue();
                    continue;
                }
                if (Fields.EXCLUDE.match(currentFieldName, parseContext.parseFlags())) {
                    include = !parser.booleanValue();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (Fields.STOP_WORDS.match(currentFieldName, parseContext.parseFlags())) {
                HashSet<String> stopWords = Sets.newHashSet();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    stopWords.add(parser.text());
                }
                mltQuery.setStopWords(stopWords);
                continue;
            }
            if ("fields".equals(currentFieldName)) {
                moreLikeFields = Lists.newLinkedList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    moreLikeFields.add(parseContext.indexName(parser.text()));
                }
                continue;
            }
            if (Fields.DOCUMENT_IDS.match(currentFieldName, parseContext.parseFlags())) {
                MultiGetRequest.parseIds(parser, items);
                continue;
            }
            if (Fields.DOCUMENTS.match(currentFieldName, parseContext.parseFlags())) {
                MultiGetRequest.parseDocuments(parser, items);
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
        }
        if (mltQuery.getLikeText() == null && items.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires at least 'like_text' or 'ids/docs' to be specified");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer(analyzer);
        if (moreLikeFields == null) {
            moreLikeFields = Lists.newArrayList(parseContext.defaultField());
        } else if (moreLikeFields.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'fields' to be non-empty");
        }
        this.removeUnsupportedFields(moreLikeFields, analyzer, failOnUnsupportedField);
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(Strings.EMPTY_ARRAY));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, mltQuery);
        }
        if (!items.isEmpty()) {
            for (MultiGetRequest.Item item : items) {
                if (item.index() == null) {
                    item.index(parseContext.index().name());
                }
                if (item.type() == null) {
                    if (parseContext.queryTypes().size() > 1) {
                        throw new QueryParsingException(parseContext.index(), "ambiguous type for item with id: " + item.id() + " and index: " + item.index());
                    }
                    item.type(parseContext.queryTypes().iterator().next());
                }
                if (item.fields() == null && item.fetchSourceContext() == null) {
                    item.fields(moreLikeFields.toArray(new String[moreLikeFields.size()]));
                    continue;
                }
                this.removeUnsupportedFields(item, analyzer, failOnUnsupportedField);
            }
            List<MoreLikeThisFetchService.LikeText> likeTexts = this.fetchService.fetch(items);
            Collection<MoreLikeThisFetchService.LikeText> likeTextsCollapsed = MoreLikeThisQueryParser.collapseTextOnField(likeTexts);
            BooleanQuery boolQuery = new BooleanQuery();
            for (MoreLikeThisFetchService.LikeText likeText : likeTextsCollapsed) {
                this.addMoreLikeThis(boolQuery, mltQuery, likeText);
            }
            if (!include) {
                TermsFilter filter = new TermsFilter("_uid", Uid.createUids(items));
                ConstantScoreQuery query = new ConstantScoreQuery(filter);
                boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
            }
            if (mltQuery.getLikeText() != null) {
                boolQuery.add(mltQuery, BooleanClause.Occur.SHOULD);
            }
            return boolQuery;
        }
        return mltQuery;
    }

    private void addMoreLikeThis(BooleanQuery boolQuery, MoreLikeThisQuery mltQuery, MoreLikeThisFetchService.LikeText likeText) {
        MoreLikeThisQuery mlt = new MoreLikeThisQuery();
        mlt.setMoreLikeFields(new String[]{likeText.field});
        mlt.setLikeText(likeText.text);
        mlt.setAnalyzer(mltQuery.getAnalyzer());
        mlt.setPercentTermsToMatch(mltQuery.getPercentTermsToMatch());
        mlt.setBoostTerms(mltQuery.isBoostTerms());
        mlt.setBoostTermsFactor(mltQuery.getBoostTermsFactor());
        mlt.setMinDocFreq(mltQuery.getMinDocFreq());
        mlt.setMaxDocFreq(mltQuery.getMaxDocFreq());
        mlt.setMinWordLen(mltQuery.getMinWordLen());
        mlt.setMaxWordLen(mltQuery.getMaxWordLen());
        mlt.setMinTermFrequency(mltQuery.getMinTermFrequency());
        mlt.setMaxQueryTerms(mltQuery.getMaxQueryTerms());
        mlt.setStopWords(mltQuery.getStopWords());
        boolQuery.add(mlt, BooleanClause.Occur.SHOULD);
    }

    private List<String> removeUnsupportedFields(List<String> moreLikeFields, Analyzer analyzer, boolean failOnUnsupportedField) throws IOException {
        Iterator<String> it = moreLikeFields.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            if (Analysis.generatesCharacterTokenStream(analyzer, fieldName)) continue;
            if (failOnUnsupportedField) {
                throw new ElasticsearchIllegalArgumentException("more_like_this doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            it.remove();
        }
        return moreLikeFields;
    }

    public static Collection<MoreLikeThisFetchService.LikeText> collapseTextOnField(Collection<MoreLikeThisFetchService.LikeText> likeTexts) {
        HashMap<String, MoreLikeThisFetchService.LikeText> collapsedTexts = new HashMap<String, MoreLikeThisFetchService.LikeText>();
        for (MoreLikeThisFetchService.LikeText likeText : likeTexts) {
            String field = likeText.field;
            String[] text = likeText.text;
            if (collapsedTexts.containsKey(field)) {
                text = ObjectArrays.concat(((MoreLikeThisFetchService.LikeText)collapsedTexts.get((Object)field)).text, text, String.class);
            }
            collapsedTexts.put(field, new MoreLikeThisFetchService.LikeText(field, text));
        }
        return collapsedTexts.values();
    }

    private void removeUnsupportedFields(MultiGetRequest.Item item, Analyzer analyzer, boolean failOnUnsupportedField) throws IOException {
        item.fields((String[])this.removeUnsupportedFields(Arrays.asList(item.fields()), analyzer, failOnUnsupportedField).toArray());
    }

    public static class Fields {
        public static final ParseField LIKE_TEXT = new ParseField("like_text", new String[0]);
        public static final ParseField MIN_TERM_FREQ = new ParseField("min_term_freq", new String[0]);
        public static final ParseField MAX_QUERY_TERMS = new ParseField("max_query_terms", new String[0]);
        public static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", "min_word_len");
        public static final ParseField MAX_WORD_LENGTH = new ParseField("max_word_length", "max_word_len");
        public static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
        public static final ParseField MAX_DOC_FREQ = new ParseField("max_doc_freq", new String[0]);
        public static final ParseField BOOST_TERMS = new ParseField("boost_terms", new String[0]);
        public static final ParseField PERCENT_TERMS_TO_MATCH = new ParseField("percent_terms_to_match", new String[0]);
        public static final ParseField FAIL_ON_UNSUPPORTED_FIELD = new ParseField("fail_on_unsupported_field", new String[0]);
        public static final ParseField STOP_WORDS = new ParseField("stop_words", new String[0]);
        public static final ParseField DOCUMENT_IDS = new ParseField("ids", new String[0]);
        public static final ParseField DOCUMENTS = new ParseField("docs", new String[0]);
        public static final ParseField INCLUDE = new ParseField("include", new String[0]);
        public static final ParseField EXCLUDE = new ParseField("exclude", new String[0]);
    }
}

