/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hppc.DoubleOpenHashSet;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;

public abstract class FieldDataTermsFilter
extends Filter {
    final IndexFieldData fieldData;

    protected FieldDataTermsFilter(IndexFieldData fieldData) {
        this.fieldData = fieldData;
    }

    public static FieldDataTermsFilter newBytes(IndexFieldData fieldData, ObjectOpenHashSet<BytesRef> terms) {
        return new BytesFieldDataFilter(fieldData, terms);
    }

    public static FieldDataTermsFilter newLongs(IndexNumericFieldData fieldData, LongOpenHashSet terms) {
        return new LongsFieldDataFilter(fieldData, terms);
    }

    public static FieldDataTermsFilter newDoubles(IndexNumericFieldData fieldData, DoubleOpenHashSet terms) {
        return new DoublesFieldDataFilter(fieldData, terms);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldDataTermsFilter)) {
            return false;
        }
        FieldDataTermsFilter that = (FieldDataTermsFilter)obj;
        if (!this.fieldData.getFieldNames().indexName().equals(that.fieldData.getFieldNames().indexName())) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public abstract int hashCode();

    public abstract String toString();

    protected static class DoublesFieldDataFilter
    extends FieldDataTermsFilter {
        final DoubleOpenHashSet terms;

        protected DoublesFieldDataFilter(IndexNumericFieldData fieldData, DoubleOpenHashSet terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public int hashCode() {
            int hashcode = this.fieldData.getFieldNames().indexName().hashCode();
            return hashcode += this.terms != null ? this.terms.hashCode() : 0;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("DoublesFieldDataFilter");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            IndexNumericFieldData indexNumericFieldData = (IndexNumericFieldData)this.fieldData;
            if (indexNumericFieldData.getNumericType().isFloatingPoint()) {
                final DoubleValues values = indexNumericFieldData.load(context).getDoubleValues();
                return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        int numVals = values.setDocument(doc);
                        for (int i = 0; i < numVals; ++i) {
                            if (!DoublesFieldDataFilter.this.terms.contains(values.nextValue())) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return null;
        }
    }

    protected static class LongsFieldDataFilter
    extends FieldDataTermsFilter {
        final LongOpenHashSet terms;

        protected LongsFieldDataFilter(IndexNumericFieldData fieldData, LongOpenHashSet terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public int hashCode() {
            int hashcode = this.fieldData.getFieldNames().indexName().hashCode();
            return hashcode += this.terms != null ? this.terms.hashCode() : 0;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("LongsFieldDataFilter:");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)this.fieldData;
            if (!numericFieldData.getNumericType().isFloatingPoint()) {
                final LongValues values = numericFieldData.load(context).getLongValues();
                return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        int numVals = values.setDocument(doc);
                        for (int i = 0; i < numVals; ++i) {
                            if (!LongsFieldDataFilter.this.terms.contains(values.nextValue())) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return null;
        }
    }

    protected static class BytesFieldDataFilter
    extends FieldDataTermsFilter {
        final ObjectOpenHashSet<BytesRef> terms;

        protected BytesFieldDataFilter(IndexFieldData fieldData, ObjectOpenHashSet<BytesRef> terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public int hashCode() {
            int hashcode = this.fieldData.getFieldNames().indexName().hashCode();
            return hashcode += this.terms != null ? this.terms.hashCode() : 0;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("BytesFieldDataFilter:");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            final BytesValues values = this.fieldData.load(context).getBytesValues();
            return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                @Override
                protected boolean matchDoc(int doc) {
                    int numVals = values.setDocument(doc);
                    for (int i = 0; i < numVals; ++i) {
                        if (!BytesFieldDataFilter.this.terms.contains(values.nextValue())) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

