/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.store.Store;

public final class DirectoryUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private DirectoryUtils() {
    }

    @Nullable
    public static Store.StoreDirectory getStoreDirectory(Directory dir) {
        Directory current = dir;
        while (true) {
            if (current instanceof Store.StoreDirectory) {
                return (Store.StoreDirectory)current;
            }
            if (current instanceof FilterDirectory) {
                current = ((FilterDirectory)current).getDelegate();
                continue;
            }
            if (!(current instanceof CompoundFileDirectory)) break;
            current = ((CompoundFileDirectory)current).getDirectory();
        }
        return null;
    }

    static final Directory getLeafDirectory(FilterDirectory dir) {
        Directory current = dir.getDelegate();
        while (true) {
            if (current instanceof FilterDirectory) {
                current = ((FilterDirectory)current).getDelegate();
                continue;
            }
            if (!(current instanceof NRTCachingDirectory)) break;
            current = ((NRTCachingDirectory)current).getDelegate();
        }
        return current;
    }

    public static <T extends Directory> T getLeaf(Directory dir, Class<T> targetClass) {
        return DirectoryUtils.getLeaf(dir, targetClass, null);
    }

    public static <T extends Directory> T getLeaf(Directory dir, Class<T> targetClass, T defaultValue) {
        Directory d = dir;
        if (dir instanceof FilterDirectory) {
            d = DirectoryUtils.getLeafDirectory((FilterDirectory)dir);
        }
        if (d instanceof FileSwitchDirectory) {
            T leaf = DirectoryUtils.getLeaf(((FileSwitchDirectory)d).getPrimaryDir(), targetClass);
            d = leaf == null ? DirectoryUtils.getLeaf(((FileSwitchDirectory)d).getSecondaryDir(), targetClass, defaultValue) : leaf;
        }
        if (d != null && targetClass.isAssignableFrom(d.getClass())) {
            return (T)((Directory)targetClass.cast(d));
        }
        return defaultValue;
    }

    static {
        boolean bl = $assertionsDisabled = !DirectoryUtils.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Version.CURRENT.luceneVersion != org.apache.lucene.util.Version.LUCENE_4_9) {
            throw new AssertionError((Object)"Remove the special case for NRTCachingDirectory - it implements FilterDirectory in 4.10");
        }
    }
}

