/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolatorIndex;

class MultiDocumentPercolatorIndex
implements PercolatorIndex {
    private final CloseableThreadLocal<MemoryIndex> cache;

    MultiDocumentPercolatorIndex(CloseableThreadLocal<MemoryIndex> cache) {
        this.cache = cache;
    }

    @Override
    public void prepare(PercolateContext context, ParsedDocument parsedDocument) {
        IndexReader[] memoryIndices = new IndexReader[parsedDocument.docs().size()];
        List<ParseContext.Document> docs = parsedDocument.docs();
        int rootDocIndex = docs.size() - 1;
        assert (rootDocIndex > 0);
        MemoryIndex rootDocMemoryIndex = null;
        for (int i = 0; i < docs.size(); ++i) {
            ParseContext.Document d = docs.get(i);
            MemoryIndex memoryIndex = rootDocIndex == i ? (rootDocMemoryIndex = this.cache.get()) : new MemoryIndex(true);
            memoryIndices[i] = this.indexDoc(d, parsedDocument.analyzer(), memoryIndex).createSearcher().getIndexReader();
        }
        MultiReader mReader = new MultiReader(memoryIndices, true);
        try {
            AtomicReader slowReader = SlowCompositeReaderWrapper.wrap(mReader);
            DocSearcher docSearcher = new DocSearcher(new IndexSearcher(slowReader), rootDocMemoryIndex);
            context.initialize(docSearcher, parsedDocument);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create index for percolator with nested document ", e);
        }
    }

    MemoryIndex indexDoc(ParseContext.Document d, Analyzer analyzer, MemoryIndex memoryIndex) {
        for (IndexableField field : d.getFields()) {
            if (!field.fieldType().indexed() && field.name().equals("_uid")) continue;
            try {
                TokenStream tokenStream = field.tokenStream(analyzer, null);
                if (tokenStream == null) continue;
                memoryIndex.addField(field.name(), tokenStream, field.boost());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create token stream", e);
            }
        }
        return memoryIndex;
    }

    private class DocSearcher
    implements Engine.Searcher {
        private final IndexSearcher searcher;
        private final MemoryIndex rootDocMemoryIndex;

        private DocSearcher(IndexSearcher searcher, MemoryIndex rootDocMemoryIndex) {
            this.searcher = searcher;
            this.rootDocMemoryIndex = rootDocMemoryIndex;
        }

        @Override
        public String source() {
            return "percolate";
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public void close() throws ElasticsearchException {
            try {
                this.searcher.getIndexReader().close();
                this.rootDocMemoryIndex.reset();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to close IndexReader in percolator with nested doc", e);
            }
        }
    }
}

