/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.get;

import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class RestMultiGetAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestMultiGetAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mget", this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", (Boolean)true);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.listenerThreaded(false);
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBoolean("realtime", null));
        String[] sFields = null;
        String sField = request.param("fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray(sField);
        }
        FetchSourceContext defaultFetchSource = FetchSourceContext.parseFromRestRequest(request);
        multiGetRequest.add(request.param("index"), request.param("type"), sFields, defaultFetchSource, request.param("routing"), RestActions.getRestContent(request), this.allowExplicitIndex);
        client.multiGet(multiGetRequest, new RestToXContentListener<MultiGetResponse>(channel));
    }
}

