/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.XSimpleBindings;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.ExpressionScriptExecutionException;
import org.elasticsearch.script.expression.ReplaceableConstValueSource;

class ExpressionScript
implements SearchScript {
    final Expression expression;
    final XSimpleBindings bindings;
    final CannedScorer scorer;
    final ValueSource source;
    final Map<String, CannedScorer> context;
    final ReplaceableConstValueSource specialValue;
    FunctionValues values;

    ExpressionScript(Expression e, XSimpleBindings b, ReplaceableConstValueSource v) {
        this.expression = e;
        this.bindings = b;
        this.scorer = new CannedScorer();
        this.context = Collections.singletonMap("scorer", this.scorer);
        this.source = this.expression.getValueSource((Bindings)this.bindings);
        this.specialValue = v;
    }

    double evaluate() {
        return this.values.doubleVal(this.scorer.docid);
    }

    @Override
    public Object run() {
        return new Double(this.evaluate());
    }

    @Override
    public float runAsFloat() {
        return (float)this.evaluate();
    }

    @Override
    public long runAsLong() {
        return (long)this.evaluate();
    }

    @Override
    public double runAsDouble() {
        return this.evaluate();
    }

    @Override
    public Object unwrap(Object value) {
        return value;
    }

    @Override
    public void setNextDocId(int d) {
        this.scorer.docid = d;
    }

    @Override
    public void setNextScore(float score) {
        this.scorer.score = score;
    }

    @Override
    public void setNextReader(AtomicReaderContext leaf) {
        try {
            this.values = this.source.getValues(this.context, leaf);
        }
        catch (IOException e) {
            throw new ExpressionScriptExecutionException("Expression failed to bind for segment", e);
        }
    }

    @Override
    public void setScorer(Scorer s) {
    }

    @Override
    public void setNextSource(Map<String, Object> source) {
    }

    @Override
    public void setNextVar(String name, Object value) {
        assert (this.specialValue != null);
        assert (name.equals("_value"));
        if (!(value instanceof Number)) {
            throw new ExpressionScriptExecutionException("Cannot use expression with text variable");
        }
        this.specialValue.setValue(((Number)value).doubleValue());
    }

    static class CannedScorer
    extends Scorer {
        protected int docid;
        protected float score;

        public CannedScorer() {
            super(null);
        }

        @Override
        public int docID() {
            return this.docid;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return 1L;
        }
    }
}

