/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalHistogram<B extends Bucket>
extends InternalAggregation
implements Histogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("histogram", "histo");
    static final Factory FACTORY = new Factory();
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalHistogram readResult(StreamInput in) throws IOException {
            InternalHistogram histogram = new InternalHistogram();
            histogram.readFrom(in);
            return histogram;
        }
    };
    protected List<B> buckets;
    private LongObjectOpenHashMap<B> bucketsMap;
    private InternalOrder order;
    @Nullable
    private ValueFormatter formatter;
    private boolean keyed;
    private long minDocCount;
    private EmptyBucketInfo emptyBucketInfo;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalHistogram() {
    }

    InternalHistogram(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, @Nullable ValueFormatter formatter, boolean keyed) {
        super(name);
        this.buckets = buckets;
        this.order = order;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.formatter = formatter;
        this.keyed = keyed;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public Collection<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public B getBucketByKey(String key) {
        return (B)this.getBucketByKey(Long.valueOf(key));
    }

    public B getBucketByKey(Number key) {
        if (this.bucketsMap == null) {
            this.bucketsMap = new LongObjectOpenHashMap(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketsMap.put(bucket.key, bucket);
            }
        }
        return (B)((Bucket)this.bucketsMap.get(key.longValue()));
    }

    protected Factory<B> getFactory() {
        return FACTORY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        LongObjectPagedHashMap<ArrayList<Bucket>> bucketsByKey = new LongObjectPagedHashMap<ArrayList<Bucket>>(reduceContext.bigArrays());
        for (InternalAggregation aggregation : aggregations) {
            InternalHistogram internalHistogram = (InternalHistogram)aggregation;
            for (Bucket bucket : internalHistogram.buckets) {
                ArrayList<Bucket> bucketList = (ArrayList<Bucket>)bucketsByKey.get(bucket.key);
                if (bucketList == null) {
                    bucketList = new ArrayList<Bucket>(aggregations.size());
                    bucketsByKey.put(bucket.key, bucketList);
                }
                bucketList.add(bucket);
            }
        }
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>((int)bucketsByKey.size());
        for (LongObjectPagedHashMap.Cursor cursor : bucketsByKey) {
            Bucket bucket;
            List sameTermBuckets = (List)cursor.value;
            bucket = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext.bigArrays());
            if (bucket.getDocCount() < this.minDocCount) continue;
            reducedBuckets.add(bucket);
        }
        bucketsByKey.close();
        if (this.minDocCount == 0L) {
            void var6_10;
            long key;
            CollectionUtil.introSort(reducedBuckets, this.order.asc ? InternalOrder.KEY_ASC.comparator() : InternalOrder.KEY_DESC.comparator());
            List list = this.order.asc ? reducedBuckets : Lists.reverse(reducedBuckets);
            Object var6_9 = null;
            ExtendedBounds bounds = this.emptyBucketInfo.bounds;
            ListIterator<B> iter = list.listIterator();
            if (bounds != null) {
                Bucket firstBucket;
                Bucket bucket = firstBucket = iter.hasNext() ? (Bucket)list.get(iter.nextIndex()) : null;
                if (firstBucket == null) {
                    if (bounds.min != null && bounds.max != null) {
                        key = bounds.min;
                        long max = bounds.max;
                        while (key <= max) {
                            iter.add(this.createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                            key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                        }
                    }
                } else if (bounds.min != null && (key = bounds.min.longValue()) < firstBucket.key) {
                    while (key < firstBucket.key) {
                        iter.add(this.createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                        key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                    }
                }
            }
            while (iter.hasNext()) {
                Bucket nextBucket = (Bucket)list.get(iter.nextIndex());
                if (var6_10 != null) {
                    key = this.emptyBucketInfo.rounding.nextRoundingValue(var6_10.key);
                    while (key < nextBucket.key) {
                        iter.add(this.createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                        key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                    }
                    assert (key == nextBucket.key);
                }
                Bucket bucket = (Bucket)iter.next();
            }
            if (bounds != null && var6_10 != null && bounds.max != null && bounds.max > var6_10.key) {
                long key2 = this.emptyBucketInfo.rounding.nextRoundingValue(var6_10.key);
                long max = bounds.max;
                while (key2 <= max) {
                    iter.add(this.createBucket(key2, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                    key2 = this.emptyBucketInfo.rounding.nextRoundingValue(key2);
                }
            }
            if (this.order != InternalOrder.KEY_ASC && this.order != InternalOrder.KEY_DESC) {
                CollectionUtil.introSort(reducedBuckets, this.order.comparator());
            }
        } else {
            CollectionUtil.introSort(reducedBuckets, this.order.comparator());
        }
        return this.getFactory().create(this.getName(), reducedBuckets, this.order, this.minDocCount, this.emptyBucketInfo, this.formatter, this.keyed);
    }

    protected B createBucket(long key, long docCount, InternalAggregations aggregations, @Nullable ValueFormatter formatter) {
        return (B)new Bucket(key, docCount, formatter, aggregations);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.order = InternalOrder.Streams.readOrder(in);
        this.minDocCount = in.readVLong();
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo = EmptyBucketInfo.readFrom(in);
        }
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> buckets = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(this.createBucket(in.readLong(), in.readVLong(), InternalAggregations.readAggregations(in), this.formatter));
        }
        this.buckets = buckets;
        this.bucketsMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalOrder.Streams.writeOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            EmptyBucketInfo.writeTo(this.emptyBucketInfo, out);
        }
        ValueFormatterStreams.writeOptional(this.formatter, out);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            out.writeLong(bucket.key);
            out.writeVLong(bucket.docCount);
            bucket.aggregations.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params, this.keyed, this.formatter);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder.endObject();
    }

    static class Factory<B extends Bucket> {
        protected Factory() {
        }

        public String type() {
            return TYPE.name();
        }

        public InternalHistogram<B> create(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, @Nullable ValueFormatter formatter, boolean keyed) {
            return new InternalHistogram<B>(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
        }

        public B createBucket(long key, long docCount, InternalAggregations aggregations, @Nullable ValueFormatter formatter) {
            return (B)new Bucket(key, docCount, formatter, aggregations);
        }
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;
        final ExtendedBounds bounds;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations) {
            this(rounding, subAggregations, null);
        }

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations, ExtendedBounds bounds) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
            this.bounds = bounds;
        }

        public static EmptyBucketInfo readFrom(StreamInput in) throws IOException {
            Rounding rounding = Rounding.Streams.read(in);
            InternalAggregations aggs = InternalAggregations.readAggregations(in);
            if (in.getVersion().onOrAfter(Version.V_1_1_0) && in.readBoolean()) {
                return new EmptyBucketInfo(rounding, aggs, ExtendedBounds.readFrom(in));
            }
            return new EmptyBucketInfo(rounding, aggs);
        }

        public static void writeTo(EmptyBucketInfo info, StreamOutput out) throws IOException {
            Rounding.Streams.write(info.rounding, out);
            info.subAggregations.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
                out.writeBoolean(info.bounds != null);
                if (info.bounds != null) {
                    info.bounds.writeTo(out);
                }
            }
        }
    }

    public static class Bucket
    implements Histogram.Bucket {
        final long key;
        final long docCount;
        @Nullable
        protected final transient ValueFormatter formatter;
        final InternalAggregations aggregations;

        public Bucket(long key, long docCount, @Nullable ValueFormatter formatter, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.formatter = formatter;
            this.aggregations = aggregations;
        }

        protected Factory<?> getFactory() {
            return FACTORY;
        }

        @Override
        public String getKey() {
            return this.formatter != null ? this.formatter.format(this.key) : ValueFormatter.RAW.format(this.key);
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(this.getKey());
        }

        @Override
        public Number getKeyAsNumber() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        <B extends Bucket> B reduce(List<B> buckets, BigArrays bigArrays) {
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregations.add((InternalAggregations)bucket.getAggregations());
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregations, bigArrays);
            return (B)this.getFactory().createBucket(this.key, docCount, aggs, this.formatter);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed, @Nullable ValueFormatter formatter) throws IOException {
            if (formatter != null && formatter != ValueFormatter.RAW) {
                StringText keyTxt = new StringText(formatter.format(this.key));
                if (keyed) {
                    builder.startObject(keyTxt.string());
                } else {
                    builder.startObject();
                }
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, (Text)keyTxt);
            } else if (keyed) {
                builder.startObject(String.valueOf(this.getKeyAsNumber()));
            } else {
                builder.startObject();
            }
            builder.field(InternalAggregation.CommonFields.KEY, this.key);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }
    }
}

