/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ValuesSource.Bytes.WithOrdinals.FieldData valuesSource;
    protected final IncludeExclude includeExclude;
    protected BytesValues.WithOrdinals globalValues;
    protected LongBitSet acceptedGlobalOrdinals;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode) {
        super(name, factories, maxOrd, aggregationContext, parent, order, bucketCountThresholds, collectionMode);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.globalValues = this.valuesSource.globalBytesValues();
        if (this.acceptedGlobalOrdinals != null) {
            this.globalValues = new FilteredOrdinals(this.globalValues, this.acceptedGlobalOrdinals);
        } else if (this.includeExclude != null) {
            this.acceptedGlobalOrdinals = this.includeExclude.acceptedGlobalOrdinals(this.globalValues, this.valuesSource);
            this.globalValues = new FilteredOrdinals(this.globalValues, this.acceptedGlobalOrdinals);
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        int numOrds = this.globalValues.setDocument(doc);
        for (int i = 0; i < numOrds; ++i) {
            long globalOrd = this.globalValues.nextOrd();
            this.collectExistingBucket(doc, globalOrd);
        }
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize(from.length, 1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        InternalTerms.Bucket bucket;
        int i;
        if (this.globalValues == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalValues.getMaxOrd(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L, null);
        for (long globalTermOrd = 0L; globalTermOrd < this.globalValues.getMaxOrd(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0) continue;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount || (spare = ordered.insertWithOverflow(spare)) != null) continue;
            spare = new OrdBucket(-1L, 0L, null);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (OrdBucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            BytesRef scratch = new BytesRef();
            GlobalOrdinalsStringTermsAggregator.copy(this.globalValues.getValueByOrd(bucket.globalOrd), scratch);
            list[i] = new StringTerms.Bucket(scratch, bucket.docCount, null);
            list[i].bucketOrd = bucket.bucketOrd;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            bucket.aggregations = bucket.docCount == 0L ? this.bucketEmptyAggregations() : this.bucketAggregations(bucket.bucketOrd);
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list));
    }

    private static final class FilteredOrdinals
    extends BytesValues.WithOrdinals {
        private final BytesValues.WithOrdinals inner;
        private final LongBitSet accepted;
        private long currentOrd;
        private long[] buffer = new long[0];
        private int bufferSlot;

        private FilteredOrdinals(BytesValues.WithOrdinals inner, LongBitSet accepted) {
            super(inner.isMultiValued());
            this.inner = inner;
            this.accepted = accepted;
        }

        @Override
        public long getMaxOrd() {
            return this.inner.getMaxOrd();
        }

        @Override
        public long getOrd(int docId) {
            long ord = this.inner.getOrd(docId);
            if (this.accepted.get(ord)) {
                this.currentOrd = ord;
                return this.currentOrd;
            }
            this.currentOrd = -1L;
            return -1L;
        }

        @Override
        public long nextOrd() {
            this.currentOrd = this.buffer[this.bufferSlot++];
            return this.currentOrd;
        }

        @Override
        public int setDocument(int docId) {
            int numDocs = this.inner.setDocument(docId);
            this.buffer = ArrayUtil.grow(this.buffer, numDocs);
            this.bufferSlot = 0;
            int numAcceptedOrds = 0;
            for (int slot = 0; slot < numDocs; ++slot) {
                long ord = this.inner.nextOrd();
                if (!this.accepted.get(ord)) continue;
                this.buffer[numAcceptedOrds] = ord;
                ++numAcceptedOrds;
            }
            return numAcceptedOrds;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.inner.getValueByOrd(ord);
        }
    }

    public static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private final IntArray segmentDocCounts;
        private BytesValues.WithOrdinals segmentOrdinals;
        private IntArray current;

        public LowCardinality(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode) {
            super(name, factories, valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, null, aggregationContext, parent, collectionMode);
            this.segmentDocCounts = this.bigArrays.newIntArray(maxOrd, true);
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            int numOrds = this.segmentOrdinals.setDocument(doc);
            for (int i = 0; i < numOrds; ++i) {
                long segmentOrd = this.segmentOrdinals.nextOrd();
                this.current.increment(segmentOrd, 1);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            if (this.segmentOrdinals != null && this.segmentOrdinals.getMaxOrd() != this.globalValues.getMaxOrd()) {
                this.mapSegmentCountsToGlobalCounts();
            }
            this.globalValues = this.valuesSource.globalBytesValues();
            this.segmentOrdinals = this.valuesSource.bytesValues();
            this.current = this.segmentOrdinals.getMaxOrd() != this.globalValues.getMaxOrd() ? this.segmentDocCounts : this.getDocCounts();
        }

        @Override
        protected void doPostCollection() {
            if (this.segmentOrdinals.getMaxOrd() != this.globalValues.getMaxOrd()) {
                this.mapSegmentCountsToGlobalCounts();
            }
        }

        @Override
        protected void doClose() {
            Releasables.close(this.segmentDocCounts);
        }

        private void mapSegmentCountsToGlobalCounts() {
            GlobalOrdinalMapping mapping = (GlobalOrdinalMapping)this.globalValues;
            int i = 0;
            while ((long)i < this.segmentDocCounts.size()) {
                int inc = this.segmentDocCounts.set(i, 0);
                if (inc != 0) {
                    long globalOrd = mapping.getGlobalOrd(i);
                    try {
                        this.incrementBucketDocCount(inc, globalOrd);
                    }
                    catch (IOException e) {
                        throw ExceptionsHelper.convertToElastic(e);
                    }
                }
                ++i;
            }
        }
    }

    public static class WithHash
    extends GlobalOrdinalsStringTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode) {
            super(name, factories, valuesSource, estimatedBucketCount, estimatedBucketCount, order, bucketCountThresholds, includeExclude, aggregationContext, parent, collectionMode);
            this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            int numOrds = this.globalValues.setDocument(doc);
            for (int i = 0; i < numOrds; ++i) {
                long globalOrd = this.globalValues.nextOrd();
                long bucketOrd = this.bucketOrds.add(globalOrd);
                if (bucketOrd < 0L) {
                    bucketOrd = -1L - bucketOrd;
                    this.collectExistingBucket(doc, bucketOrd);
                    continue;
                }
                this.collectBucket(doc, bucketOrd);
            }
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.bucketOrds);
        }
    }

    static class OrdBucket
    extends InternalTerms.Bucket {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount, InternalAggregations aggregations) {
            super(docCount, aggregations);
            this.globalOrd = globalOrd;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Long.compare(this.globalOrd, ((OrdBucket)other).globalOrd);
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getKeyAsText() {
            throw new UnsupportedOperationException();
        }

        @Override
        Object getKeyAsObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        InternalTerms.Bucket newBucket(long docCount, InternalAggregations aggs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

