/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class LongTermsAggregator
extends TermsAggregator {
    protected final ValuesSource.Numeric valuesSource;
    @Nullable
    protected final ValueFormatter formatter;
    protected final LongHash bucketOrds;
    private LongValues values;

    public LongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, @Nullable ValueFormat format, long estimatedBucketCount, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, estimatedBucketCount, aggregationContext, parent, bucketCountThresholds, order, subAggCollectMode);
        this.valuesSource = valuesSource;
        this.formatter = format != null ? format.formatter() : null;
        this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.longValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int valuesCount = this.values.setDocument(doc);
        for (int i = 0; i < valuesCount; ++i) {
            long val = this.values.nextValue();
            long bucketOrdinal = this.bucketOrds.add(val);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(doc, bucketOrdinal);
                continue;
            }
            this.collectBucket(doc, bucketOrdinal);
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        int i;
        assert (owningBucketOrdinal == 0L);
        if (this.bucketCountThresholds.getMinDocCount() == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.bucketCountThresholds.getRequiredSize())) {
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                LongValues values = this.valuesSource.longValues();
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    int valueCount = values.setDocument(docId);
                    for (i = 0; i < valueCount; ++i) {
                        this.bucketOrds.add(values.nextValue());
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        LongTerms.Bucket spare = null;
        for (long i2 = 0L; i2 < this.bucketOrds.size(); ++i2) {
            if (spare == null) {
                spare = new LongTerms.Bucket(0L, 0L, null);
            }
            spare.term = this.bucketOrds.get(i2);
            spare.docCount = this.bucketDocCount(i2);
            spare.bucketOrd = i2;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount) continue;
            spare = ordered.insertWithOverflow(spare);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            LongTerms.Bucket bucket = (LongTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            list[i].aggregations = this.bucketAggregations(list[i].bucketOrd);
        }
        return new LongTerms(this.name, this.order, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongTerms(this.name, this.order, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

