/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.max;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalMax
extends InternalNumericMetricsAggregation.SingleValue
implements Max {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("max");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalMax readResult(StreamInput in) throws IOException {
            InternalMax result = new InternalMax();
            result.readFrom(in);
            return result;
        }
    };
    private double max;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalMax() {
    }

    public InternalMax(String name, double max) {
        super(name);
        this.max = max;
    }

    @Override
    public double value() {
        return this.max;
    }

    @Override
    public double getValue() {
        return this.max;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalMax reduce(InternalAggregation.ReduceContext reduceContext) {
        double max = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            max = Math.max(max, ((InternalMax)aggregation).max);
        }
        return new InternalMax(this.name, max);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.max = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.max);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        boolean hasValue = !Double.isInfinite(this.max);
        builder.field(InternalAggregation.CommonFields.VALUE, hasValue ? Double.valueOf(this.max) : null);
        if (hasValue && this.valueFormatter != null) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.max));
        }
        builder.endObject();
        return builder;
    }
}

