/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsContext;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;

public class TopHitsAggregator
extends MetricsAggregator
implements ScorerAware {
    private final FetchPhase fetchPhase;
    private final TopHitsContext topHitsContext;
    private final LongObjectPagedHashMap<TopDocsCollector> topDocsCollectors;
    private Scorer currentScorer;
    private AtomicReaderContext currentContext;

    public TopHitsAggregator(FetchPhase fetchPhase, TopHitsContext topHitsContext, String name, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.fetchPhase = fetchPhase;
        this.topDocsCollectors = new LongObjectPagedHashMap(estimatedBucketsCount, context.bigArrays());
        this.topHitsContext = topHitsContext;
        context.registerScorerAware(this);
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TopDocsCollector topDocsCollector = this.topDocsCollectors.get(owningBucketOrdinal);
        if (topDocsCollector == null) {
            return this.buildEmptyAggregation();
        }
        TopDocs topDocs = topDocsCollector.topDocs();
        if (topDocs.totalHits == 0) {
            return this.buildEmptyAggregation();
        }
        this.topHitsContext.queryResult().topDocs(topDocs);
        int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
        }
        this.topHitsContext.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
        this.fetchPhase.execute(this.topHitsContext);
        FetchSearchResult fetchResult = this.topHitsContext.fetchResult();
        InternalSearchHit[] internalHits = fetchResult.fetchResult().hits().internalHits();
        for (int i = 0; i < internalHits.length; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            InternalSearchHit searchHitFields = internalHits[i];
            searchHitFields.shard(this.topHitsContext.shardTarget());
            searchHitFields.score(scoreDoc.score);
            if (!(scoreDoc instanceof FieldDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            searchHitFields.sortValues(fieldDoc.fields);
        }
        return new InternalTopHits(this.name, this.topHitsContext.from(), this.topHitsContext.size(), this.topHitsContext.sort(), topDocs, fetchResult.hits());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalTopHits(this.name, this.topHitsContext.from(), this.topHitsContext.size(), this.topHitsContext.sort(), Lucene.EMPTY_TOP_DOCS, InternalSearchHits.empty());
    }

    @Override
    public void collect(int docId, long bucketOrdinal) throws IOException {
        TopDocsCollector topDocsCollector = this.topDocsCollectors.get(bucketOrdinal);
        if (topDocsCollector == null) {
            Sort sort = this.topHitsContext.sort();
            int topN = this.topHitsContext.from() + this.topHitsContext.size();
            topDocsCollector = sort != null ? TopFieldCollector.create(sort, topN, true, this.topHitsContext.trackScores(), this.topHitsContext.trackScores(), false) : TopScoreDocCollector.create(topN, false);
            this.topDocsCollectors.put(bucketOrdinal, topDocsCollector);
            topDocsCollector.setNextReader(this.currentContext);
            topDocsCollector.setScorer(this.currentScorer);
        }
        topDocsCollector.collect(docId);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        this.currentContext = context;
        for (LongObjectPagedHashMap.Cursor<TopDocsCollector> cursor : this.topDocsCollectors) {
            try {
                ((TopDocsCollector)cursor.value).setNextReader(context);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.currentScorer = scorer;
        for (LongObjectPagedHashMap.Cursor<TopDocsCollector> cursor : this.topDocsCollectors) {
            try {
                ((TopDocsCollector)cursor.value).setScorer(scorer);
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }
    }

    @Override
    protected void doClose() {
        Releasables.close(new Releasable[]{this.topDocsCollectors});
    }

    public static class Factory
    extends AggregatorFactory {
        private final FetchPhase fetchPhase;
        private final TopHitsContext topHitsContext;

        public Factory(String name, FetchPhase fetchPhase, TopHitsContext topHitsContext) {
            super(name, InternalTopHits.TYPE.name());
            this.fetchPhase = fetchPhase;
            this.topHitsContext = topHitsContext;
        }

        @Override
        public Aggregator create(AggregationContext aggregationContext, Aggregator parent, long expectedBucketsCount) {
            return new TopHitsAggregator(this.fetchPhase, this.topHitsContext, this.name, expectedBucketsCount, aggregationContext, parent);
        }

        @Override
        public AggregatorFactory subFactories(AggregatorFactories subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.type + "] cannot accept sub-aggregations");
        }
    }
}

