/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ScriptValues;

public class ScriptDoubleValues
extends DoubleValues
implements ScriptValues {
    final SearchScript script;
    private Object value;
    private double[] values = new double[1];
    private int valueCount;
    private int valueOffset;

    public ScriptDoubleValues(SearchScript script) {
        super(true);
        this.script = script;
    }

    @Override
    public SearchScript script() {
        return this.script;
    }

    @Override
    public int setDocument(int docId) {
        this.docId = docId;
        this.script.setNextDocId(docId);
        this.value = this.script.run();
        if (this.value == null) {
            this.valueCount = 0;
        } else if (this.value instanceof Number) {
            this.valueCount = 1;
            this.values[0] = ((Number)this.value).doubleValue();
        } else if (this.value.getClass().isArray()) {
            this.valueCount = Array.getLength(this.value);
            this.values = ArrayUtil.grow(this.values, this.valueCount);
            for (int i = 0; i < this.valueCount; ++i) {
                this.values[i] = ((Number)Array.get(this.value, i)).doubleValue();
            }
        } else if (this.value instanceof Collection) {
            this.valueCount = ((Collection)this.value).size();
            this.values = ArrayUtil.grow(this.values, this.valueCount);
            int i = 0;
            Iterator it = ((Collection)this.value).iterator();
            while (it.hasNext()) {
                this.values[i] = ((Number)it.next()).doubleValue();
                ++i;
            }
            assert (i == this.valueCount);
        } else {
            throw new AggregationExecutionException("Unsupported script value [" + this.value + "]");
        }
        this.valueOffset = 0;
        return this.valueCount;
    }

    @Override
    public double nextValue() {
        assert (this.valueOffset < this.valueCount);
        return this.values[this.valueOffset++];
    }
}

