/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.chrono.ISOChronology;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.TimeZoneRounding;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.datehistogram.CountDateHistogramFacetExecutor;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.ValueDateHistogramFacetExecutor;
import org.elasticsearch.search.facet.datehistogram.ValueScriptDateHistogramFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class DateHistogramFacetParser
extends AbstractComponent
implements FacetParser {
    private final ImmutableMap<String, DateTimeUnit> dateTimeUnits;

    @Inject
    public DateHistogramFacetParser(Settings settings) {
        super(settings);
        InternalDateHistogramFacet.registerStreams();
        this.dateTimeUnits = MapBuilder.newMapBuilder().put("year", DateTimeUnit.YEAR_OF_CENTURY).put("1y", DateTimeUnit.YEAR_OF_CENTURY).put("quarter", DateTimeUnit.QUARTER).put("1q", DateTimeUnit.QUARTER).put("month", DateTimeUnit.MONTH_OF_YEAR).put("1M", DateTimeUnit.MONTH_OF_YEAR).put("week", DateTimeUnit.WEEK_OF_WEEKYEAR).put("1w", DateTimeUnit.WEEK_OF_WEEKYEAR).put("day", DateTimeUnit.DAY_OF_MONTH).put("1d", DateTimeUnit.DAY_OF_MONTH).put("hour", DateTimeUnit.HOUR_OF_DAY).put("1h", DateTimeUnit.HOUR_OF_DAY).put("minute", DateTimeUnit.MINUTES_OF_HOUR).put("1m", DateTimeUnit.MINUTES_OF_HOUR).put("second", DateTimeUnit.SECOND_OF_MINUTE).put("1s", DateTimeUnit.SECOND_OF_MINUTE).immutableMap();
    }

    @Override
    public String[] types() {
        return new String[]{"date_histogram", "dateHistogram"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        String valueScript = null;
        ScriptService.ScriptType valueScriptType = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        String interval = null;
        DateTimeZone preZone = DateTimeZone.UTC;
        DateTimeZone postZone = DateTimeZone.UTC;
        boolean preZoneAdjustLargeInterval = false;
        long preOffset = 0L;
        long postOffset = 0L;
        float factor = 1.0f;
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        DateHistogramFacet.ComparatorType comparatorType = DateHistogramFacet.ComparatorType.TIME;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("interval".equals(fieldName)) {
                interval = parser.text();
                continue;
            }
            if ("time_zone".equals(fieldName) || "timeZone".equals(fieldName)) {
                preZone = this.parseZone(parser, token);
                continue;
            }
            if ("pre_zone".equals(fieldName) || "preZone".equals(fieldName)) {
                preZone = this.parseZone(parser, token);
                continue;
            }
            if ("pre_zone_adjust_large_interval".equals(fieldName) || "preZoneAdjustLargeInterval".equals(fieldName)) {
                preZoneAdjustLargeInterval = parser.booleanValue();
                continue;
            }
            if ("post_zone".equals(fieldName) || "postZone".equals(fieldName)) {
                postZone = this.parseZone(parser, token);
                continue;
            }
            if ("pre_offset".equals(fieldName) || "preOffset".equals(fieldName)) {
                preOffset = this.parseOffset(parser.text());
                continue;
            }
            if ("post_offset".equals(fieldName) || "postOffset".equals(fieldName)) {
                postOffset = this.parseOffset(parser.text());
                continue;
            }
            if ("factor".equals(fieldName)) {
                factor = parser.floatValue();
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_INLINE.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.INLINE;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_ID.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_FILE.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if ("order".equals(fieldName) || "comparator".equals(fieldName)) {
                comparatorType = DateHistogramFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if (!ScriptService.SCRIPT_LANG.match(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (interval == null) {
            throw new FacetPhaseExecutionException(facetName, "[interval] is required to be set for histogram facet");
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for histogram facet, either using [field] or using [key_field]");
        }
        FieldMapper keyMapper = context.smartNameFieldMapper(keyField);
        if (keyMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "(key) field [" + keyField + "] not found");
        }
        IndexNumericFieldData keyIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(keyMapper);
        DateTimeUnit dateTimeUnit = this.dateTimeUnits.get(interval);
        TimeZoneRounding.Builder tzRoundingBuilder = dateTimeUnit != null ? TimeZoneRounding.builder(dateTimeUnit) : TimeZoneRounding.builder(TimeValue.parseTimeValue(interval, null));
        TimeZoneRounding tzRounding = tzRoundingBuilder.preZone(preZone).postZone(postZone).preZoneAdjustLargeInterval(preZoneAdjustLargeInterval).preOffset(preOffset).postOffset(postOffset).factor(factor).build();
        if (valueScript != null) {
            SearchScript script = context.scriptService().search(context.lookup(), scriptLang, valueScript, valueScriptType, params);
            return new ValueScriptDateHistogramFacetExecutor(keyIndexFieldData, script, tzRounding, comparatorType, context.cacheRecycler());
        }
        if (valueField != null) {
            FieldMapper valueMapper = context.smartNameFieldMapper(valueField);
            if (valueMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "(value) field [" + valueField + "] not found");
            }
            IndexNumericFieldData valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(valueMapper);
            return new ValueDateHistogramFacetExecutor(keyIndexFieldData, valueIndexFieldData, tzRounding, comparatorType, context.cacheRecycler());
        }
        return new CountDateHistogramFacetExecutor(keyIndexFieldData, tzRounding, comparatorType, context.cacheRecycler());
    }

    private long parseOffset(String offset) throws IOException {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue(offset.substring(1), null).millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue(offset.substring(beginIndex), null).millis();
    }

    private DateTimeZone parseZone(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return DateTimeZone.forOffsetHours(parser.intValue());
        }
        String text = parser.text();
        int index = text.indexOf(58);
        if (index != -1) {
            int beginIndex = text.charAt(0) == '+' ? 1 : 0;
            return DateTimeZone.forOffsetHoursMinutes(Integer.parseInt(text.substring(beginIndex, index)), Integer.parseInt(text.substring(index + 1)));
        }
        return DateTimeZone.forID(text);
    }
}

