/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.doubles;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.hppc.DoubleIntOpenHashMap;
import org.elasticsearch.common.hppc.DoubleOpenHashSet;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.doubles.InternalDoubleTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsDoubleFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int shardSize;
    private final SearchScript script;
    private final ImmutableSet<BytesRef> excluded;
    final Recycler.V<DoubleIntOpenHashMap> facets;
    long missing;
    long total;

    public TermsDoubleFacetExecutor(IndexNumericFieldData indexFieldData, int size, int shardSize, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, SearchScript script, CacheRecycler cacheRecycler) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.script = script;
        this.excluded = excluded;
        this.facets = cacheRecycler.doubleIntMap(-1);
        if (allTerms) {
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                int maxDoc = readerContext.reader().maxDoc();
                DoubleValues values = indexFieldData.load(readerContext).getDoubleValues();
                for (int docId = 0; docId < maxDoc; ++docId) {
                    int numValues = values.setDocument(docId);
                    DoubleIntOpenHashMap map = this.facets.v();
                    for (int i = 0; i < numValues; ++i) {
                        map.putIfAbsent(values.nextValue(), 0);
                    }
                }
            }
        }
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        if (this.facets.v().isEmpty()) {
            this.facets.close();
            return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, ImmutableList.of(), this.missing, this.total);
        }
        boolean[] states = this.facets.v().allocated;
        double[] keys = this.facets.v().keys;
        int[] values = this.facets.v().values;
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.shardSize, this.comparatorType.comparator());
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                ordered.insertWithOverflow(new InternalDoubleTermsFacet.DoubleEntry(keys[i], values[i]));
            }
            InternalDoubleTermsFacet.DoubleEntry[] list = new InternalDoubleTermsFacet.DoubleEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalDoubleTermsFacet.DoubleEntry)ordered.pop();
            }
            this.facets.close();
            return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.shardSize);
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            ordered.add(new InternalDoubleTermsFacet.DoubleEntry(keys[i], values[i]));
        }
        this.facets.close();
        return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }

    public static class StaticAggregatorValueProc
    extends DoubleFacetAggregatorBase {
        private final DoubleIntOpenHashMap facets;

        public StaticAggregatorValueProc(DoubleIntOpenHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int docId, double value) {
            this.facets.addTo(value, 1);
        }

        public final DoubleIntOpenHashMap facets() {
            return this.facets;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final DoubleOpenHashSet excluded;

        public AggregatorValueProc(DoubleIntOpenHashMap facets, Set<BytesRef> excluded, SearchScript script) {
            super(facets);
            this.script = script;
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new DoubleOpenHashSet(excluded.size());
                for (BytesRef s : excluded) {
                    this.excluded.add(Double.parseDouble(s.utf8ToString()));
                }
            }
        }

        @Override
        public void onValue(int docId, double value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).doubleValue();
                }
            }
            super.onValue(docId, value);
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StaticAggregatorValueProc aggregator;
        private DoubleValues values;

        public Collector() {
            this.aggregator = TermsDoubleFacetExecutor.this.script == null && TermsDoubleFacetExecutor.this.excluded.isEmpty() ? new StaticAggregatorValueProc(TermsDoubleFacetExecutor.this.facets.v()) : new AggregatorValueProc(TermsDoubleFacetExecutor.this.facets.v(), TermsDoubleFacetExecutor.this.excluded, TermsDoubleFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsDoubleFacetExecutor.this.script != null) {
                TermsDoubleFacetExecutor.this.script.setScorer(scorer);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = TermsDoubleFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
            if (TermsDoubleFacetExecutor.this.script != null) {
                TermsDoubleFacetExecutor.this.script.setNextReader(context);
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            TermsDoubleFacetExecutor.this.missing = this.aggregator.missing();
            TermsDoubleFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

