/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;

public class HashedAggregator {
    private int missing;
    private int total;
    private final HashCount hash;
    private final HashCount assertHash = this.getAssertHash();

    public HashedAggregator() {
        this.hash = new BytesRefHashHashCount(new BytesRefHash(10L, BigArrays.NON_RECYCLING_INSTANCE));
    }

    public void onDoc(int docId, BytesValues values) {
        int length = values.setDocument(docId);
        int pendingMissing = 1;
        this.total += length;
        for (int i = 0; i < length; ++i) {
            BytesRef value = values.nextValue();
            this.onValue(docId, value, value.hashCode(), values);
            pendingMissing = 0;
        }
        this.missing += pendingMissing;
    }

    public void addValue(BytesRef value, int hashCode, BytesValues values) {
        boolean added = this.hash.addNoCount(value, hashCode, values);
        assert (this.assertHash.addNoCount(value, hashCode, values) == added) : "asserting counter diverged from current counter - value: " + value + " hash: " + hashCode;
    }

    protected void onValue(int docId, BytesRef value, int hashCode, BytesValues values) {
        boolean added = this.hash.add(value, hashCode, values);
        assert (this.assertHash.add(BytesRef.deepCopyOf(value), hashCode, values) == added) : "asserting counter diverged from current counter - value: " + value + " hash: " + hashCode;
    }

    public final int missing() {
        return this.missing;
    }

    public final int total() {
        return this.total;
    }

    public final boolean isEmpty() {
        return this.hash.size() == 0;
    }

    public BytesRefCountIterator getIter() {
        assert (this.hash.size() == this.assertHash.size());
        return this.hash.iter();
    }

    public void release() {
        this.hash.release();
    }

    public static InternalFacet buildFacet(String facetName, int size, int shardSize, long missing, long total, TermsFacet.ComparatorType comparatorType, HashedAggregator aggregator) {
        if (aggregator.isEmpty()) {
            return new InternalStringTermsFacet(facetName, comparatorType, size, ImmutableList.of(), missing, total);
        }
        if (shardSize < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(shardSize, comparatorType.comparator());
            BytesRefCountIterator iter = aggregator.getIter();
            while (iter.next() != null) {
                ordered.insertWithOverflow(new InternalStringTermsFacet.TermEntry(iter.makeSafe(), iter.count()));
            }
            InternalStringTermsFacet.TermEntry[] list = new InternalStringTermsFacet.TermEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalStringTermsFacet.TermEntry)ordered.pop();
            }
            return new InternalStringTermsFacet(facetName, comparatorType, size, Arrays.asList(list), missing, total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(comparatorType.comparator(), shardSize);
        BytesRefCountIterator iter = aggregator.getIter();
        while (iter.next() != null) {
            ordered.add(new InternalStringTermsFacet.TermEntry(iter.makeSafe(), iter.count()));
        }
        return new InternalStringTermsFacet(facetName, comparatorType, size, ordered, missing, total);
    }

    private HashCount getAssertHash() {
        AssertingHashCount count = null;
        assert ((count = new AssertingHashCount()) != null);
        return count;
    }

    private static final class AssertingHashCount
    implements HashCount {
        private final ObjectIntOpenHashMap<HashedBytesRef> valuesAndCount = new ObjectIntOpenHashMap();
        private HashedBytesRef spare = new HashedBytesRef();

        private AssertingHashCount() {
        }

        @Override
        public boolean add(BytesRef value, int hashCode, BytesValues values) {
            int adjustedValue = this.valuesAndCount.addTo(this.spare.reset(value, hashCode), 1);
            assert (adjustedValue >= 1);
            if (adjustedValue == 1) {
                this.spare.bytes = BytesRef.deepCopyOf(value);
                this.spare = new HashedBytesRef();
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.valuesAndCount.size();
        }

        @Override
        public BytesRefCountIterator iter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }

        @Override
        public boolean addNoCount(BytesRef value, int hashCode, BytesValues values) {
            if (!this.valuesAndCount.containsKey(this.spare.reset(value, hashCode))) {
                this.valuesAndCount.addTo(this.spare.reset(BytesRef.deepCopyOf(value), hashCode), 0);
                this.spare = new HashedBytesRef();
                return true;
            }
            return false;
        }
    }

    private static final class BytesRefHashHashCount
    implements HashCount {
        private final BytesRefHash hash;
        private int[] counts = new int[10];

        public BytesRefHashHashCount(BytesRefHash hash) {
            this.hash = hash;
        }

        @Override
        public boolean add(BytesRef value, int hashCode, BytesValues values) {
            int key = (int)this.hash.add(value, hashCode);
            if (key < 0) {
                key = -key - 1;
            } else if (key >= this.counts.length) {
                this.counts = ArrayUtil.grow(this.counts, key + 1);
            }
            int n = key;
            int n2 = this.counts[n];
            this.counts[n] = n2 + 1;
            return n2 == 0;
        }

        @Override
        public boolean addNoCount(BytesRef value, int hashCode, BytesValues values) {
            boolean added;
            int key = (int)this.hash.add(value, hashCode);
            boolean bl = added = key >= 0;
            if (key < 0) {
                key = -key - 1;
            } else if (key >= this.counts.length) {
                this.counts = ArrayUtil.grow(this.counts, key + 1);
            }
            return added;
        }

        @Override
        public BytesRefCountIterator iter() {
            return new BytesRefCountIteratorImpl();
        }

        @Override
        public int size() {
            return (int)this.hash.size();
        }

        @Override
        public void release() {
            this.hash.close();
        }

        public final class BytesRefCountIteratorImpl
        implements BytesRefCountIterator {
            final BytesRef spare = new BytesRef();
            private final int size;
            private int current = 0;
            private int currentCount = -1;

            BytesRefCountIteratorImpl() {
                this.size = (int)BytesRefHashHashCount.this.hash.size();
            }

            @Override
            public BytesRef next() {
                if (this.current < this.size) {
                    this.currentCount = BytesRefHashHashCount.this.counts[this.current];
                    BytesRefHashHashCount.this.hash.get(this.current++, this.spare);
                    return this.spare;
                }
                this.currentCount = -1;
                return null;
            }

            @Override
            public BytesRef makeSafe() {
                return BytesRef.deepCopyOf(this.spare);
            }

            @Override
            public int count() {
                return this.currentCount;
            }

            @Override
            public boolean shared() {
                return true;
            }
        }
    }

    private static interface HashCount {
        public boolean add(BytesRef var1, int var2, BytesValues var3);

        public boolean addNoCount(BytesRef var1, int var2, BytesValues var3);

        public void release();

        public int size();

        public BytesRefCountIterator iter();
    }

    public static interface BytesRefCountIterator {
        public BytesRef next();

        public BytesRef makeSafe();

        public int count();

        public boolean shared();
    }
}

