/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.FastCharArrayReader;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public final class SuggestUtils {
    public static final Comparator<SuggestWord> LUCENE_FREQUENCY = new SuggestWordFrequencyComparator();
    public static final Comparator<SuggestWord> SCORE_COMPARATOR = SuggestWordQueue.DEFAULT_COMPARATOR;

    private SuggestUtils() {
    }

    public static DirectSpellChecker getDirectSpellChecker(DirectSpellcheckerSettings suggestion) {
        Comparator<SuggestWord> comparator;
        DirectSpellChecker directSpellChecker = new DirectSpellChecker();
        directSpellChecker.setAccuracy(suggestion.accuracy());
        switch (suggestion.sort()) {
            case SCORE: {
                comparator = SCORE_COMPARATOR;
                break;
            }
            case FREQUENCY: {
                comparator = LUCENE_FREQUENCY;
                break;
            }
            default: {
                throw new ElasticsearchIllegalArgumentException("Illegal suggest sort: " + (Object)((Object)suggestion.sort()));
            }
        }
        directSpellChecker.setComparator(comparator);
        directSpellChecker.setDistance(suggestion.stringDistance());
        directSpellChecker.setMaxEdits(suggestion.maxEdits());
        directSpellChecker.setMaxInspections(suggestion.maxInspections());
        directSpellChecker.setMaxQueryFrequency(suggestion.maxTermFreq());
        directSpellChecker.setMinPrefix(suggestion.prefixLength());
        directSpellChecker.setMinQueryLength(suggestion.minWordLength());
        directSpellChecker.setThresholdFrequency(suggestion.minDocFreq());
        directSpellChecker.setLowerCaseTerms(false);
        return directSpellChecker;
    }

    public static BytesRef join(BytesRef separator, BytesRef result, BytesRef ... toJoin) {
        int len = separator.length * toJoin.length - 1;
        for (BytesRef br : toJoin) {
            len += br.length;
        }
        result.grow(len);
        return SuggestUtils.joinPreAllocated(separator, result, toJoin);
    }

    public static BytesRef joinPreAllocated(BytesRef separator, BytesRef result, BytesRef ... toJoin) {
        result.length = 0;
        result.offset = 0;
        for (int i = 0; i < toJoin.length - 1; ++i) {
            BytesRef br = toJoin[i];
            System.arraycopy(br.bytes, br.offset, result.bytes, result.offset, br.length);
            result.offset += br.length;
            System.arraycopy(separator.bytes, separator.offset, result.bytes, result.offset, separator.length);
            result.offset += separator.length;
        }
        BytesRef br = toJoin[toJoin.length - 1];
        System.arraycopy(br.bytes, br.offset, result.bytes, result.offset, br.length);
        result.length = result.offset + br.length;
        result.offset = 0;
        return result;
    }

    public static int analyze(Analyzer analyzer, BytesRef toAnalyze, String field, TokenConsumer consumer, CharsRef spare) throws IOException {
        UnicodeUtil.UTF8toUTF16(toAnalyze, spare);
        return SuggestUtils.analyze(analyzer, spare, field, consumer);
    }

    public static int analyze(Analyzer analyzer, CharsRef toAnalyze, String field, TokenConsumer consumer) throws IOException {
        TokenStream ts = analyzer.tokenStream(field, new FastCharArrayReader(toAnalyze.chars, toAnalyze.offset, toAnalyze.length));
        return SuggestUtils.analyze(ts, consumer);
    }

    public static int analyze(TokenStream stream, TokenConsumer consumer) throws IOException {
        stream.reset();
        consumer.reset(stream);
        int numTokens = 0;
        while (stream.incrementToken()) {
            consumer.nextToken();
            ++numTokens;
        }
        consumer.end();
        stream.close();
        return numTokens;
    }

    public static SuggestMode resolveSuggestMode(String suggestMode) {
        if ("missing".equals(suggestMode = suggestMode.toLowerCase(Locale.US))) {
            return SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
        }
        if ("popular".equals(suggestMode)) {
            return SuggestMode.SUGGEST_MORE_POPULAR;
        }
        if ("always".equals(suggestMode)) {
            return SuggestMode.SUGGEST_ALWAYS;
        }
        throw new ElasticsearchIllegalArgumentException("Illegal suggest mode " + suggestMode);
    }

    public static Suggest.Suggestion.Sort resolveSort(String sortVal) {
        if ("score".equals(sortVal)) {
            return Suggest.Suggestion.Sort.SCORE;
        }
        if ("frequency".equals(sortVal)) {
            return Suggest.Suggestion.Sort.FREQUENCY;
        }
        throw new ElasticsearchIllegalArgumentException("Illegal suggest sort " + sortVal);
    }

    public static StringDistance resolveDistance(String distanceVal) {
        if ("internal".equals(distanceVal)) {
            return DirectSpellChecker.INTERNAL_LEVENSHTEIN;
        }
        if ("damerau_levenshtein".equals(distanceVal) || "damerauLevenshtein".equals(distanceVal)) {
            return new LuceneLevenshteinDistance();
        }
        if ("levenstein".equals(distanceVal)) {
            return new LevensteinDistance();
        }
        if ("jarowinkler".equals(distanceVal)) {
            return new JaroWinklerDistance();
        }
        if ("ngram".equals(distanceVal)) {
            return new NGramDistance();
        }
        throw new ElasticsearchIllegalArgumentException("Illegal distance option " + distanceVal);
    }

    public static boolean parseDirectSpellcheckerSettings(XContentParser parser, String fieldName, DirectSpellcheckerSettings suggestion) throws IOException {
        if ("accuracy".equals(fieldName)) {
            suggestion.accuracy(parser.floatValue());
        } else if (Fields.SUGGEST_MODE.match(fieldName)) {
            suggestion.suggestMode(SuggestUtils.resolveSuggestMode(parser.text()));
        } else if ("sort".equals(fieldName)) {
            suggestion.sort(SuggestUtils.resolveSort(parser.text()));
        } else if (Fields.STRING_DISTANCE.match(fieldName)) {
            suggestion.stringDistance(SuggestUtils.resolveDistance(parser.text()));
        } else if (Fields.MAX_EDITS.match(fieldName)) {
            suggestion.maxEdits(parser.intValue());
            if (suggestion.maxEdits() < 1 || suggestion.maxEdits() > 2) {
                throw new ElasticsearchIllegalArgumentException("Illegal max_edits value " + suggestion.maxEdits());
            }
        } else if (Fields.MAX_INSPECTIONS.match(fieldName)) {
            suggestion.maxInspections(parser.intValue());
        } else if (Fields.MAX_TERM_FREQ.match(fieldName)) {
            suggestion.maxTermFreq(parser.floatValue());
        } else if (Fields.PREFIX_LENGTH.match(fieldName)) {
            suggestion.prefixLength(parser.intValue());
        } else if (Fields.MIN_WORD_LENGTH.match(fieldName)) {
            suggestion.minQueryLength(parser.intValue());
        } else if (Fields.MIN_DOC_FREQ.match(fieldName)) {
            suggestion.minDocFreq(parser.floatValue());
        } else {
            return false;
        }
        return true;
    }

    public static boolean parseSuggestContext(XContentParser parser, MapperService mapperService, String fieldName, SuggestionSearchContext.SuggestionContext suggestion) throws IOException {
        if ("analyzer".equals(fieldName)) {
            String analyzerName = parser.text();
            NamedAnalyzer analyzer = mapperService.analysisService().analyzer(analyzerName);
            if (analyzer == null) {
                throw new ElasticsearchIllegalArgumentException("Analyzer [" + analyzerName + "] doesn't exists");
            }
            suggestion.setAnalyzer(analyzer);
        } else if ("field".equals(fieldName)) {
            suggestion.setField(parser.text());
        } else if ("size".equals(fieldName)) {
            suggestion.setSize(parser.intValue());
        } else if (Fields.SHARD_SIZE.match(fieldName)) {
            suggestion.setShardSize(parser.intValue());
        } else {
            return false;
        }
        return true;
    }

    public static void verifySuggestion(MapperService mapperService, BytesRef globalText, SuggestionSearchContext.SuggestionContext suggestion) {
        if (suggestion.getField() == null) {
            throw new ElasticsearchIllegalArgumentException("The required field option is missing");
        }
        if (suggestion.getText() == null) {
            if (globalText == null) {
                throw new ElasticsearchIllegalArgumentException("The required text option is missing");
            }
            suggestion.setText(globalText);
        }
        if (suggestion.getAnalyzer() == null) {
            suggestion.setAnalyzer(mapperService.searchAnalyzer());
        }
        if (suggestion.getShardSize() == -1) {
            suggestion.setShardSize(Math.max(suggestion.getSize(), 5));
        }
    }

    public static ShingleTokenFilterFactory.Factory getShingleFilterFactory(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof CustomAnalyzer) {
            TokenFilterFactory[] tokenFilters;
            CustomAnalyzer a = (CustomAnalyzer)analyzer;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = a.tokenFilters()) {
                if (tokenFilterFactory instanceof ShingleTokenFilterFactory) {
                    return ((ShingleTokenFilterFactory)tokenFilterFactory).getInnerFactory();
                }
                if (!(tokenFilterFactory instanceof ShingleTokenFilterFactory.Factory)) continue;
                return (ShingleTokenFilterFactory.Factory)tokenFilterFactory;
            }
        }
        return null;
    }

    public static class Fields {
        public static final ParseField STRING_DISTANCE = new ParseField("string_distance", new String[0]);
        public static final ParseField SUGGEST_MODE = new ParseField("suggest_mode", new String[0]);
        public static final ParseField MAX_EDITS = new ParseField("max_edits", new String[0]);
        public static final ParseField MAX_INSPECTIONS = new ParseField("max_inspections", new String[0]);
        public static final ParseField MAX_TERM_FREQ = new ParseField("max_term_freq", new String[0]);
        public static final ParseField PREFIX_LENGTH = new ParseField("prefix_length", "prefix_len");
        public static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", "min_word_len");
        public static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
        public static final ParseField SHARD_SIZE = new ParseField("shard_size", new String[0]);
    }

    public static abstract class TokenConsumer {
        protected CharTermAttribute charTermAttr;
        protected PositionIncrementAttribute posIncAttr;
        protected OffsetAttribute offsetAttr;

        public void reset(TokenStream stream) {
            this.charTermAttr = stream.addAttribute(CharTermAttribute.class);
            this.posIncAttr = stream.addAttribute(PositionIncrementAttribute.class);
            this.offsetAttr = stream.addAttribute(OffsetAttribute.class);
        }

        protected BytesRef fillBytesRef(BytesRef spare) {
            spare.offset = 0;
            spare.length = spare.bytes.length;
            char[] source = this.charTermAttr.buffer();
            UnicodeUtil.UTF16toUTF8(source, 0, this.charTermAttr.length(), spare);
            return spare;
        }

        public abstract void nextToken() throws IOException;

        public void end() {
        }
    }
}

