/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import org.elasticsearch.search.suggest.phrase.NoisyChannelSpellChecker;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestParser;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class PhraseSuggester
extends Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef(" ");
    private static final String SUGGESTION_TEMPLATE_VAR_NAME = "suggestion";
    private final Client client;
    private final ScriptService scriptService;

    @Inject
    public PhraseSuggester(Client client, ScriptService scriptService) {
        this.client = client;
        this.scriptService = scriptService;
    }

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, PhraseSuggestionContext suggestion, IndexReader indexReader, CharsRef spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelyhood().floatValue();
        PhraseSuggestion response = new PhraseSuggestion(name, suggestion.getSize());
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        int numGenerators = generators.size();
        ArrayList<DirectCandidateGenerator> gens = new ArrayList<DirectCandidateGenerator>(generators.size());
        for (int i = 0; i < numGenerators; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = SuggestUtils.getDirectSpellChecker(generator);
            Terms terms = MultiFields.getTerms(indexReader, generator.field());
            if (terms == null) continue;
            gens.add(new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter(), terms));
        }
        String suggestField = suggestion.getField();
        Terms suggestTerms = MultiFields.getTerms(indexReader, suggestField);
        if (gens.size() > 0 && suggestTerms != null) {
            NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram(), suggestion.getTokenLimit());
            BytesRef separator = suggestion.separator();
            TokenStream stream = checker.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());
            WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestTerms, suggestField, realWordErrorLikelihood, separator);
            NoisyChannelSpellChecker.Result checkerResult = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens.toArray(new CandidateGenerator[gens.size()])), suggestion.maxErrors(), suggestion.getShardSize(), indexReader, wordScorer, separator, suggestion.confidence(), suggestion.gramSize());
            PhraseSuggestion.Entry resultEntry = this.buildResultEntry(suggestion, spare, checkerResult.cutoffScore);
            response.addTerm(resultEntry);
            BytesRef byteSpare = new BytesRef();
            MultiSearchResponse multiSearchResponse = this.collate(suggestion, checkerResult, byteSpare, spare);
            for (int i = 0; i < checkerResult.corrections.length; ++i) {
                if (!PhraseSuggester.hasMatchingDocs(multiSearchResponse, i)) continue;
                Correction correction = checkerResult.corrections[i];
                UnicodeUtil.UTF8toUTF16(correction.join(this.SEPARATOR, byteSpare, null, null), spare);
                StringText phrase = new StringText(spare.toString());
                StringText highlighted = null;
                if (suggestion.getPreTag() != null) {
                    UnicodeUtil.UTF8toUTF16(correction.join(this.SEPARATOR, byteSpare, suggestion.getPreTag(), suggestion.getPostTag()), spare);
                    highlighted = new StringText(spare.toString());
                }
                resultEntry.addOption(new Suggest.Suggestion.Entry.Option(phrase, highlighted, (float)correction.score));
            }
        } else {
            response.addTerm(this.buildResultEntry(suggestion, spare, Double.MIN_VALUE));
        }
        return response;
    }

    private PhraseSuggestion.Entry buildResultEntry(PhraseSuggestionContext suggestion, CharsRef spare, double cutoffScore) {
        UnicodeUtil.UTF8toUTF16(suggestion.getText(), spare);
        return new PhraseSuggestion.Entry(new StringText(spare.toString()), 0, spare.length, cutoffScore);
    }

    private MultiSearchResponse collate(PhraseSuggestionContext suggestion, NoisyChannelSpellChecker.Result checkerResult, BytesRef byteSpare, CharsRef spare) throws IOException {
        CompiledScript collateQueryScript = suggestion.getCollateQueryScript();
        CompiledScript collateFilterScript = suggestion.getCollateFilterScript();
        MultiSearchResponse multiSearchResponse = null;
        if (collateQueryScript != null) {
            multiSearchResponse = this.fetchMatchingDocCountResponses(checkerResult.corrections, collateQueryScript, false, suggestion, byteSpare, spare);
        } else if (collateFilterScript != null) {
            multiSearchResponse = this.fetchMatchingDocCountResponses(checkerResult.corrections, collateFilterScript, true, suggestion, byteSpare, spare);
        }
        return multiSearchResponse;
    }

    private MultiSearchResponse fetchMatchingDocCountResponses(Correction[] corrections, CompiledScript collateScript, boolean isFilter, PhraseSuggestionContext suggestions, BytesRef byteSpare, CharsRef spare) throws IOException {
        Map<String, Object> vars = suggestions.getCollateScriptParams();
        MultiSearchResponse multiSearchResponse = null;
        MultiSearchRequestBuilder multiSearchRequestBuilder = this.client.prepareMultiSearch();
        boolean requestAdded = false;
        for (Correction correction : corrections) {
            UnicodeUtil.UTF8toUTF16(correction.join(this.SEPARATOR, byteSpare, null, null), spare);
            vars.put(SUGGESTION_TEMPLATE_VAR_NAME, spare.toString());
            ExecutableScript executable = this.scriptService.executable(collateScript, vars);
            BytesReference querySource = (BytesReference)executable.run();
            requestAdded = true;
            SearchRequestBuilder req = isFilter ? this.client.prepareSearch(new String[0]).setPreference(suggestions.getPreference()).setQuery(QueryBuilders.constantScoreQuery(FilterBuilders.bytesFilter(querySource))).setSearchType(SearchType.COUNT) : this.client.prepareSearch(new String[0]).setPreference(suggestions.getPreference()).setQuery(querySource).setSearchType(SearchType.COUNT);
            multiSearchRequestBuilder.add(req);
        }
        if (requestAdded) {
            multiSearchResponse = (MultiSearchResponse)multiSearchRequestBuilder.get();
        }
        return multiSearchResponse;
    }

    private static boolean hasMatchingDocs(MultiSearchResponse multiSearchResponse, int index) {
        if (multiSearchResponse == null) {
            return true;
        }
        MultiSearchResponse.Item item = multiSearchResponse.getResponses()[index];
        if (!item.isFailure()) {
            SearchResponse resp = item.getResponse();
            return resp.getHits().totalHits() > 0L;
        }
        throw new ElasticsearchException("Collate request failed: " + item.getFailureMessage());
    }

    ScriptService scriptService() {
        return this.scriptService;
    }

    @Override
    public String[] names() {
        return new String[]{"phrase"};
    }

    @Override
    public SuggestContextParser getContextParser() {
        return new PhraseSuggestParser(this);
    }
}

