/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ProfileService;
import io.fabric8.api.jmx.ProfileDTO;
import io.fabric8.common.util.Objects;
import io.fabric8.core.jmx.Links;
import io.fabric8.rest.ResourceSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
public class ProfileResource
extends ResourceSupport {
    private final Profile profile;

    public ProfileResource(ResourceSupport parent, Profile profile) {
        super(parent, profile.isOverlay() ? "/overlay" : "profile/" + profile.getId());
        this.profile = profile;
    }

    public String toString() {
        return "ProfileResource{profile=" + this.profile + '}';
    }

    @GET
    public ProfileDTO details() {
        String overlay = this.profile.isOverlay() ? null : this.getLink("overlay");
        return new ProfileDTO(this.profile, this.getLink("containers"), overlay, this.getLink("requirements"), this.getLink("fileNames"));
    }

    @DELETE
    public void deleteProfile() {
        FabricService fabricService = this.getFabricService();
        Objects.notNull((Object)fabricService, (String)"fabricService");
        ProfileService profileService = this.getProfileService();
        Objects.notNull((Object)profileService, (String)"profileService");
        profileService.deleteProfile(fabricService, this.profile.getVersion(), this.profile.getId(), true);
    }

    @GET
    @Path(value="containers")
    public Map<String, String> containers() {
        FabricService fabricService = this.getFabricService();
        if (fabricService != null) {
            List containers = Containers.containersForProfile((Container[])fabricService.getContainers(), (String)this.profile.getId(), (String)this.profile.getVersion());
            List keys = Containers.containerIds((Iterable)containers);
            ResourceSupport node = this;
            for (int i = 0; i < 2 && node != null; node = node.getParent(), ++i) {
            }
            String baseURI = node != null ? node.getBaseUri() : "";
            return Links.mapIdsToLinks((Iterable)keys, (String)(baseURI + "/container/"));
        }
        this.noFabricService();
        return Collections.emptyMap();
    }

    @Path(value="overlay")
    public ProfileResource overlay() {
        ProfileService profileService;
        if (!this.profile.isOverlay() && (profileService = this.getProfileService()) != null) {
            Profile overlay = profileService.getOverlayProfile(this.profile);
            return new ProfileResource((ResourceSupport)this, overlay);
        }
        return null;
    }

    @GET
    @Path(value="requirements")
    public ProfileRequirements requirements() {
        FabricRequirements requirements = this.getFabricService().getRequirements();
        if (requirements != null) {
            return requirements.getOrCreateProfileRequirement(this.profile.getId());
        }
        return null;
    }

    @POST
    @Path(value="requirements")
    public void setRequirements(ProfileRequirements profileRequirements) throws IOException {
        FabricService service = this.getFabricService();
        FabricRequirements requirements = service.getRequirements();
        if (requirements != null) {
            requirements.addOrUpdateProfileRequirements(profileRequirements);
            service.setRequirements(requirements);
        }
    }

    @GET
    @Path(value="fileNames")
    public Map<String, String> fileNames() {
        Set fileNames = this.profile.getConfigurationFileNames();
        return this.mapToLinks(fileNames, "/file/");
    }

    @GET
    @Path(value="file/{fileName: .*}")
    public Response file(@PathParam(value="fileName") String fileName) {
        byte[] bytes = this.profile.getFileConfiguration(fileName);
        if (bytes == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No file: " + fileName + " for profile: " + this.profile.getId() + " version: " + this.profile.getVersion())).build();
        }
        String mediaType = ProfileResource.guessMediaType(fileName);
        return Response.ok((Object)bytes, (String)mediaType).build();
    }

    public static String guessMediaType(String fileName) {
        if (fileName.endsWith(".xml")) {
            return "application/xml";
        }
        if (fileName.endsWith(".wadl")) {
            return "application/wadl+xml";
        }
        if (fileName.endsWith(".wsdl")) {
            return "application/wsdl+xml";
        }
        if (fileName.endsWith(".xsd")) {
            return "application/xsd+xml";
        }
        if (fileName.endsWith(".json")) {
            return "application/json";
        }
        if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            return "application/html";
        }
        if (fileName.endsWith(".properties")) {
            return "text/x-java-properties";
        }
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return "text/plain";
    }
}

