/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.ProfileDTO;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.rest.FabricResource;
import io.fabric8.rest.ProfileResource;
import io.fabric8.rest.ResourceSupport;
import io.fabric8.rest.VersionDTO;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class VersionResource
extends ResourceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FabricResource.class);
    private final FabricResource fabricResource;
    private final Version version;

    public VersionResource(FabricResource fabricResource, Version version) {
        super(fabricResource, "/version/" + version.getId() + "/");
        this.fabricResource = fabricResource;
        this.version = version;
    }

    public String toString() {
        return "VersionResource{version=" + this.version + '}';
    }

    @GET
    public VersionDTO details() {
        return new VersionDTO(this.getLink("profiles"));
    }

    @GET
    @Path(value="profiles")
    public Map<String, String> profiles() {
        if (this.version != null) {
            List profileIds = Profiles.profileIds((Iterable)this.version.getProfiles());
            return this.mapToLinks(profileIds, "profile/");
        }
        return Collections.EMPTY_MAP;
    }

    @POST
    public Response createProfile(ProfileDTO profileDTO) throws URISyntaxException {
        Objects.notNull((Object)profileDTO, (String)"profileDTO");
        FabricService fabricService = this.getFabricService();
        Objects.notNull((Object)fabricService, (String)"fabricService");
        ProfileService profileService = this.getProfileService();
        Objects.notNull((Object)profileService, (String)"profileService");
        String id = profileDTO.getId();
        if (Strings.isNullOrBlank((String)id)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No id specified for the profile to be created").build();
        }
        URI location = new URI(this.getBaseUri() + "profile/" + id);
        String versionId = this.version.getId();
        if (profileService.hasProfile(versionId, id)) {
            return Response.seeOther((URI)location).entity((Object)("Profile already exists for id: " + id)).build();
        }
        profileDTO.setVersion(versionId);
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)id);
        profileDTO.populateBuilder(fabricService, profileService, builder);
        Profile profile = builder.getProfile();
        profileService.createProfile(profile);
        return Response.created((URI)location).build();
    }

    @Path(value="profile/{profileId}")
    public ProfileResource version(@PathParam(value="profileId") String profileId) {
        Profile profile;
        if (Strings.isNotBlank((String)profileId) && this.version != null && this.version.hasProfile(profileId) && (profile = this.version.getRequiredProfile(profileId)) != null) {
            return new ProfileResource((ResourceSupport)this, profile);
        }
        return null;
    }

    @Override
    public FabricService getFabricService() {
        return this.fabricResource.getFabricService();
    }

    public FabricResource getFabricResource() {
        return this.fabricResource;
    }
}

