/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.ProfileRequirements;
import java.util.List;

public class ProfileStatus {
    private final String profile;
    private final ProfileRequirements requirements;
    private int count;

    public ProfileStatus(String profile, ProfileRequirements requirements) {
        this.profile = profile;
        this.requirements = requirements;
    }

    public String toString() {
        return "ProfileStatus[" + this.profile + ": " + this.count + "; " + this.requirements + "]";
    }

    public void incrementCount() {
        ++this.count;
    }

    public ProfileRequirements requirements() {
        return this.requirements;
    }

    public int getCount() {
        return this.count;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Integer getMinimumInstances() {
        return this.requirements.getMinimumInstances();
    }

    public double getHealth() {
        return this.requirements.getHealth(this.getCount());
    }

    public double getHealth(int instances) {
        return this.requirements.getHealth(instances);
    }

    public List<String> getDependentProfiles() {
        return this.requirements.getDependentProfiles();
    }

    public void setProfile(String profile) {
        this.requirements.setProfile(profile);
    }

    public void setMinimumInstances(Integer minimumInstances) {
        this.requirements.setMinimumInstances(minimumInstances);
    }

    public void setDependentProfiles(List<String> dependentProfiles) {
        this.requirements.setDependentProfiles(dependentProfiles);
    }

    public Integer getMaximumInstances() {
        return this.requirements.getMaximumInstances();
    }

    public void setMaximumInstances(Integer maximumInstances) {
        this.requirements.setMaximumInstances(maximumInstances);
    }
}

