/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.gravia;

import io.fabric8.api.gravia.IllegalStateAssertion;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceLocator {
    public static final Long DEFAULT_TIMEOUT = 10000L;

    private ServiceLocator() {
    }

    public static BundleContext getSystemContext() {
        BundleContext result = null;
        ClassLoader classLoader = ServiceLocator.class.getClassLoader();
        if (classLoader instanceof BundleReference) {
            BundleReference bndref = (BundleReference)classLoader;
            result = bndref.getBundle().getBundleContext().getBundle(0L).getBundleContext();
        }
        return result;
    }

    public static <T> T getService(Class<T> type) {
        BundleContext bundleContext = ServiceLocator.getSystemContext();
        ServiceReference sref = bundleContext.getServiceReference(type);
        return (T)(sref != null ? bundleContext.getService(sref) : null);
    }

    public static <T> T getService(BundleContext bundleContext, Class<T> type) {
        ServiceReference sref = bundleContext.getServiceReference(type);
        return (T)(sref != null ? bundleContext.getService(sref) : null);
    }

    public static <T> T getRequiredService(Class<T> type) {
        return ServiceLocator.getRequiredService(ServiceLocator.getSystemContext(), type);
    }

    public static <T> T getRequiredService(BundleContext bundleContext, Class<T> type) {
        T service = ServiceLocator.getService(bundleContext, type);
        IllegalStateAssertion.assertNotNull(service, "Service not available: " + type.getName());
        return service;
    }

    public static <T> T awaitService(Class<T> type) {
        BundleContext bundleContext = ServiceLocator.getSystemContext();
        return ServiceLocator.awaitService(bundleContext, type, null, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(BundleContext bundleContext, Class<T> type) {
        return ServiceLocator.awaitService(bundleContext, type, null, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(Class<T> type, String filterspec) {
        BundleContext bundleContext = ServiceLocator.getSystemContext();
        return ServiceLocator.awaitService(bundleContext, type, filterspec, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(Class<T> type, long timeout, TimeUnit unit) {
        BundleContext bundleContext = ServiceLocator.getSystemContext();
        return ServiceLocator.awaitService(bundleContext, type, null, timeout, unit);
    }

    public static <T> T awaitService(Class<T> type, String filterspec, long timeout, TimeUnit unit) {
        BundleContext bundleContext = ServiceLocator.getSystemContext();
        return ServiceLocator.awaitService(bundleContext, type, filterspec, timeout, unit);
    }

    public static <T> T awaitService(final BundleContext bundleContext, Class<T> type, String filterspec, long timeout, TimeUnit unit) {
        Filter serviceFilter;
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference serviceRef = new AtomicReference();
        try {
            serviceFilter = filterspec != null ? bundleContext.createFilter(filterspec) : null;
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker<T, T>(bundleContext, type, null){

            public T addingService(ServiceReference<T> sref) {
                Object service = super.addingService(sref);
                if (serviceFilter == null || serviceFilter.match(sref)) {
                    serviceRef.set(bundleContext.getService(sref));
                    latch.countDown();
                }
                return service;
            }
        };){
            if (!latch.await(timeout, unit)) {
                String srvspec = (type != null ? type.getName() : "") + (serviceFilter != null ? serviceFilter : "");
                throw new IllegalStateException("Cannot obtain service: " + srvspec);
            }
            Object srvspec = serviceRef.get();
            return (T)srvspec;
        }
    }
}

