/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.mxbean;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class ManagementUtils {
    private ManagementUtils() {
    }

    public static JMXConnector getJMXConnector(String jmxServiceURL, Map<String, Object> env, long timeout, TimeUnit unit) {
        return ManagementUtils.getJMXConnectorInternal(jmxServiceURL, env, timeout, unit);
    }

    public static Map<String, Object> getDefaultEnvironment(String jmxServiceURL) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        return env;
    }

    private static JMXConnector getJMXConnectorInternal(String jmxServiceURL, Map<String, Object> env, long timeout, TimeUnit unit) {
        JMXServiceURL serviceURL;
        try {
            serviceURL = new JMXServiceURL(jmxServiceURL);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        Exception lastException = null;
        long now = System.currentTimeMillis();
        long end = now + unit.toMillis(timeout);
        while (now <= end) {
            try {
                return JMXConnectorFactory.connect(serviceURL, env);
            }
            catch (Exception ex) {
                lastException = ex;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                now = System.currentTimeMillis();
            }
        }
        throw new IllegalStateException("Cannot obtain JMXConnector for: " + jmxServiceURL, lastException);
    }
}

