/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.api.VersionSequence;
import io.fabric8.api.gravia.IllegalStateAssertion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-create", scope="fabric", description="Create a new version, copying all of the profiles from the current latest version into the new version")
public class VersionCreateAction
extends AbstractAction {
    @Option(name="--parent", description="The parent version. By default, use the latest version as the parent.")
    private String parentVersion;
    @Option(name="--default", description="Set the created version to be the new default version.")
    private Boolean defaultVersion;
    @Option(name="--description", description="The description notes of this version.")
    private String description;
    @Argument(index=0, description="The new version to create. If not specified, defaults to the next minor version.", required=false)
    private String versionId;
    private final FabricService fabricService;

    VersionCreateAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version targetVersion;
        String latestVersion = null;
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        List versions = profileService.getVersions();
        if (versions.size() > 0) {
            latestVersion = (String)versions.get(versions.size() - 1);
        }
        if (this.versionId == null) {
            IllegalStateAssertion.assertNotNull(latestVersion, (String)"Cannot default the new version name as there are no versions available");
            VersionSequence sequence = new VersionSequence(latestVersion);
            this.versionId = sequence.next().getName();
        }
        String sourceId = null;
        if (this.parentVersion == null) {
            sourceId = latestVersion;
        } else {
            IllegalStateAssertion.assertTrue((Boolean)profileService.hasVersion(this.parentVersion), (String)("Cannot find parent version: " + this.parentVersion));
            sourceId = this.parentVersion;
        }
        if (sourceId != null) {
            Map<String, String> attributes = this.description != null ? Collections.singletonMap("description", this.description) : null;
            targetVersion = profileService.createVersionFrom(sourceId, this.versionId, attributes);
            System.out.println("Created version: " + this.versionId + " as copy of: " + sourceId);
        } else {
            VersionBuilder builder = VersionBuilder.Factory.create((String)this.versionId);
            if (this.description != null) {
                builder.addAttribute("description", this.description);
            }
            targetVersion = profileService.createVersion(builder.getVersion());
            System.out.println("Create version: " + this.versionId);
        }
        if (this.defaultVersion == Boolean.TRUE) {
            this.fabricService.setDefaultVersionId(targetVersion.getId());
        }
        return null;
    }
}

