/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch;

import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.mvel.MetricsStorageServiceImpl;
import io.fabric8.insight.storage.StorageService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticsearchStorage
implements StorageService,
MetricsStorageService,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractElasticsearchStorage.class);
    private static final SimpleDateFormat indexFormat = new SimpleDateFormat("yyyy.MM.dd");
    private int max = 1000;
    protected Thread thread;
    protected volatile boolean running;
    private BlockingQueue<ActionRequest> queue = new LinkedBlockingQueue<ActionRequest>();
    private MetricsStorageService metricsStorage = new MetricsStorageServiceImpl((StorageService)this);

    public void store(String type, long timestamp, QueryResult queryResult) {
        this.metricsStorage.store(type, timestamp, queryResult);
    }

    public void store(String type, long timestamp, String jsonData) {
        Date ts = new Date(timestamp);
        Date utc = new Date(ts.getTime() + (long)(ts.getTimezoneOffset() * 60000));
        IndexRequest ir = ((IndexRequest)new IndexRequest().index("insight-" + indexFormat.format(utc))).type(type).source(jsonData).create(true);
        this.queue.add((ActionRequest)ir);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                ActionRequest req = this.queue.take();
                BulkRequest bulk = new BulkRequest();
                for (int nb = 0; req != null && (nb == 0 || nb < this.max); ++nb) {
                    bulk.add(req);
                    req = (ActionRequest)this.queue.poll();
                }
                if (bulk.numberOfActions() <= 0) continue;
                BulkResponse rep = (BulkResponse)this.getNode().client().bulk(bulk).actionGet();
                for (BulkItemResponse bir : rep.getItems()) {
                    if (!bir.isFailed()) continue;
                    LOGGER.warn("Error executing request: {}", (Object)bir.getFailureMessage());
                }
            }
            catch (Exception e) {
                if (!this.running) continue;
                LOGGER.warn("Error while sending requests", (Throwable)e);
            }
        }
    }

    public abstract Node getNode();
}

