/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch;

import io.fabric8.common.util.JMXUtils;
import io.fabric8.insight.elasticsearch.ElasticsearchMBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.node.Node;

@Component(immediate=true)
@Service(value={ElasticsearchMBean.class})
public class Elasticsearch
implements ElasticsearchMBean {
    @Reference
    private MBeanServer mbeanServer;
    @Reference(name="node", referenceInterface=Node.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
    private final Map<String, Set<Node>> nodesClusterMap = new ConcurrentHashMap<String, Set<Node>>();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)new ObjectName("io.fabric8.insight:type=Elasticsearch"));
    }

    @Deactivate
    void deactivate(Map<String, ?> configuration) throws Exception {
        JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)new ObjectName("io.fabric8.insight:type=Elasticsearch"));
    }

    @Override
    public NodeInfo[] getNodeInfo(String clusterName) {
        Iterator<Node> i$;
        Set<Node> nodeSet = this.nodesClusterMap.get(clusterName);
        if (nodeSet != null && (i$ = nodeSet.iterator()).hasNext()) {
            Node node = i$.next();
            ClusterAdminClient client = node.client().admin().cluster();
            NodesInfoResponse response = (NodesInfoResponse)client.prepareNodesInfo(new String[0]).all().execute().actionGet();
            return (NodeInfo[])response.getNodes();
        }
        return null;
    }

    @Override
    public String getRestUrl(String clusterName) {
        NodeInfo[] nodes = this.getNodeInfo(clusterName);
        if (nodes != null && nodes.length > 0) {
            String publishAddress = nodes[0].getHttp().address().publishAddress().toString().substring(0);
            return publishAddress.substring(0, publishAddress.lastIndexOf(93)).replaceFirst("inet\\[.*\\/", "http://");
        }
        return null;
    }

    @Override
    public ClusterHealthResponse getClusterHealth(String clusterName) {
        Iterator<Node> i$;
        Set<Node> nodeSet = this.nodesClusterMap.get(clusterName);
        if (nodeSet != null && (i$ = nodeSet.iterator()).hasNext()) {
            Node node = i$.next();
            ClusterAdminClient client = node.client().admin().cluster();
            ClusterHealthResponse response = (ClusterHealthResponse)client.prepareHealth(new String[0]).execute().actionGet();
            return response;
        }
        return null;
    }

    public void bindNode(Node node) {
        String clusterName = node.settings().get("cluster.name");
        Set<Node> nodeSet = this.nodesClusterMap.get(clusterName);
        if (nodeSet == null) {
            nodeSet = new HashSet<Node>();
            this.nodesClusterMap.put(clusterName, nodeSet);
        }
        nodeSet.add(node);
    }

    public void unbindNode(Node node) {
        String clusterName = node.settings().get("cluster.name");
        Set<Node> nodeSet = this.nodesClusterMap.get(clusterName);
        if (nodeSet != null) {
            nodeSet.remove(node);
            if (nodeSet.isEmpty()) {
                this.nodesClusterMap.remove(clusterName);
            }
        }
    }

    protected void bindMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    protected void unbindMbeanServer(MBeanServer mBeanServer) {
        if (this.mbeanServer == mBeanServer) {
            this.mbeanServer = null;
        }
    }
}

