/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

@Component(name="io.fabric8.elasticsearch", policy=ConfigurationPolicy.REQUIRE, configurationFactory=true, metatype=false)
@Service(value={Node.class})
public class ElasticsearchNode
implements Node {
    private Node nodeDelegate;

    @Activate
    protected void activate(Map<String, Object> props) throws Exception {
        HashMap<String, String> stringProps = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            stringProps.put(entry.getKey(), entry.getValue().toString());
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        String configFilePath = (String)stringProps.get("config");
        if (configFilePath != null) {
            settings.loadFromUrl(new URL(configFilePath));
        }
        settings.put(stringProps).classLoader(this.getClass().getClassLoader());
        this.nodeDelegate = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).node();
    }

    @Deactivate
    protected void deactivate() {
        if (this.nodeDelegate != null && !this.nodeDelegate.isClosed()) {
            this.nodeDelegate.close();
        }
    }

    public Settings settings() {
        return this.nodeDelegate.settings();
    }

    public Client client() {
        return this.nodeDelegate.client();
    }

    public Node start() {
        return this.nodeDelegate.start();
    }

    public Node stop() {
        return this.nodeDelegate.stop();
    }

    public void close() {
        this.nodeDelegate.close();
    }

    public boolean isClosed() {
        return false;
    }
}

