/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf;

import io.fabric8.cxf.CxfNodeState;
import io.fabric8.cxf.FabricClientListener;
import io.fabric8.cxf.FabricServerListener;
import io.fabric8.cxf.LoadBalanceStrategy;
import io.fabric8.cxf.LoadBalanceTargetSelector;
import io.fabric8.cxf.RandomLoadBalanceStrategy;
import io.fabric8.cxf.ServerAddressResolver;
import io.fabric8.groups.Group;
import io.fabric8.groups.internal.ZooKeeperGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

public class FabricLoadBalancerFeature
extends AbstractFeature
implements BusLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalancerFeature.class);
    private static final String ZOOKEEPER_URL = "zookeeper.url";
    private static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    private volatile CuratorFramework curator;
    private String zooKeeperUrl;
    private String zooKeeperPassword;
    private String zkRoot = "/fabric/cxf/endpoints/";
    private String fabricPath;
    private boolean shouldCloseZkClient = false;
    private int maximumConnectionTimeout = 10000;
    private volatile Group group;
    private LoadBalanceStrategy loadBalanceStrategy;
    private ServerAddressResolver addressResolver;

    public void initialize(Client client, Bus bus) {
        this.setupClientConduitSelector(client);
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        if (interceptorProvider instanceof ConduitSelectorHolder) {
            ConduitSelectorHolder holder = (ConduitSelectorHolder)interceptorProvider;
            ConduitSelector oldSelector = holder.getConduitSelector();
            LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
            selector.setEndpoint(oldSelector.getEndpoint());
            try {
                selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
                holder.setConduitSelector((ConduitSelector)selector);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot setup the LoadBalanceStrategy due to " + e));
            }
            BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            manager.registerLifeCycleListener((BusLifeCycleListener)this);
        }
    }

    public void initialize(Bus bus) {
        try {
            FabricServerListener lister = new FabricServerListener((Group<CxfNodeState>)this.getGroup(), this.addressResolver, this.getCurator());
            ServerLifeCycleManager serverMgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
            if (serverMgr != null) {
                serverMgr.registerListener((ServerLifeCycleListener)lister);
            } else {
                LOG.error((Object)"Cannot find the ServerLifeCycleManager, we cannot publish the service through fabric.");
            }
            ClientLifeCycleManager clientMgr = (ClientLifeCycleManager)bus.getExtension(ClientLifeCycleManager.class);
            FabricClientListener clientListener = new FabricClientListener(this);
            if (clientMgr != null) {
                clientMgr.registerListener((ClientLifeCycleListener)clientListener);
            } else {
                LOG.error((Object)"Cannot find the ClientLifeCycleManager, the client cannot access the service through fabric");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot initialize the bus with FabricLoadBalancerFeature due to " + ex));
        }
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener((BusLifeCycleListener)this);
    }

    protected void setupClientConduitSelector(Client client) {
        LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
        selector.setEndpoint(client.getEndpoint());
        try {
            selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
            client.setConduitSelector((ConduitSelector)selector);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot setup the LoadBalanceStrategy due to " + e));
        }
    }

    protected LoadBalanceStrategy getDefaultLoadBalanceStrategy() {
        return new RandomLoadBalanceStrategy();
    }

    protected LoadBalanceTargetSelector getDefaultLoadBalanceTargetSelector() {
        return new LoadBalanceTargetSelector();
    }

    public synchronized Group getGroup() throws Exception {
        if (this.group == null) {
            this.group = new ZooKeeperGroup(this.getCurator(), this.zkRoot + this.fabricPath, CxfNodeState.class);
            this.group.start();
        }
        return this.group;
    }

    public void destroy() throws Exception {
        if (this.group != null) {
            this.group.close();
        }
        if (this.curator != null && this.isShouldCloseZkClient()) {
            this.curator.close();
        }
    }

    public String getFabricPath() {
        return this.fabricPath;
    }

    public void setFabricPath(String fabricPath) {
        this.fabricPath = fabricPath;
    }

    public synchronized CuratorFramework getCurator() throws Exception {
        if (this.curator == null) {
            String password;
            String connectString = this.getZooKeeperUrl();
            if (connectString == null) {
                connectString = System.getProperty(ZOOKEEPER_URL, "localhost:2181");
            }
            if ((password = this.getZooKeeperPassword()) == null) {
                System.getProperty(ZOOKEEPER_PASSWORD);
            }
            LOG.debug((Object)("Zookeeper client not find in camel registry, creating new with connection " + connectString));
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryOneTime(1000)).connectionTimeoutMs(this.maximumConnectionTimeout);
            if (password != null && !password.isEmpty()) {
                builder.authorization("digest", ("fabric:" + password).getBytes());
            }
            CuratorFramework client = builder.build();
            LOG.debug((Object)("Starting curator " + this.curator));
            client.start();
            this.curator = client;
            this.setShouldCloseZkClient(true);
        }
        this.curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() throws Exception {
        if (this.loadBalanceStrategy == null) {
            this.loadBalanceStrategy = this.getDefaultLoadBalanceStrategy();
        }
        if (this.loadBalanceStrategy.getGroup() == null) {
            this.loadBalanceStrategy.setGroup((Group<CxfNodeState>)this.getGroup());
        }
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy) {
        this.loadBalanceStrategy = strategy;
    }

    public void setShouldCloseZkClient(boolean closeZkClient) {
        this.shouldCloseZkClient = closeZkClient;
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public int getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(int maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    public ServerAddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(ServerAddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public String getZooKeeperPassword() {
        return this.zooKeeperPassword;
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zooKeeperPassword = zooKeeperPassword;
    }

    public void initComplete() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot shut down the curator due to " + e));
        }
    }
}

