/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf;

import io.fabric8.cxf.ServerAddressResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrefixAddressResolver
implements ServerAddressResolver {
    private static final transient Log LOG = LogFactory.getLog(PrefixAddressResolver.class);
    private String prefixAddress;

    public void setPrefixAddress(String prefixAddress) {
        this.prefixAddress = prefixAddress;
    }

    public String getPrefixAddress() {
        return this.prefixAddress;
    }

    @Override
    public String getFullAddress(String address) {
        if (!(address.startsWith("http://") || address.startsWith("jms://") || address.startsWith("camel://") || address.startsWith("nmr://"))) {
            if (this.prefixAddress == null || this.prefixAddress.trim().length() == 0) {
                LOG.warn((Object)("Set the full address for the CXF service to " + address + " , as the prefixAddress is empty."));
                return address;
            }
            return this.prefixAddress + address;
        }
        return address;
    }
}

