/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.endpoint;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class IgnorePropertiesBackedByTransientFields
implements VisibilityChecker<IgnorePropertiesBackedByTransientFields> {
    private static final transient Logger LOG = LogUtils.getL7dLogger(IgnorePropertiesBackedByTransientFields.class);
    private final VisibilityChecker<?> defaultChecker;

    public IgnorePropertiesBackedByTransientFields(VisibilityChecker<?> defaultChecker) {
        this.defaultChecker = defaultChecker;
    }

    public boolean isGetterVisible(AnnotatedMethod method) {
        boolean answer = this.defaultChecker.isGetterVisible(method);
        if (answer) {
            answer = this.isGetterMethodWithFieldVisible(method, this.getGetterFieldName(method.getName()), method.getDeclaringClass()) && this.isGetterMethodRetItselfVisible(method.getMember(), method.getDeclaringClass());
        }
        return answer;
    }

    public boolean isGetterVisible(Method method) {
        boolean answer = this.defaultChecker.isGetterVisible(method);
        if (answer) {
            answer = this.isGetterMethodWithFieldVisible(method, this.getGetterFieldName(method.getName()), method.getDeclaringClass()) && this.isGetterMethodRetItselfVisible(method, method.getDeclaringClass());
        }
        return answer;
    }

    public boolean isIsGetterVisible(AnnotatedMethod method) {
        boolean answer = this.defaultChecker.isIsGetterVisible(method);
        if (answer) {
            answer = this.isGetterMethodWithFieldVisible(method, this.getIsGetterFieldName(method.getName()), method.getDeclaringClass()) && this.isGetterMethodRetItselfVisible(method.getMember(), method.getDeclaringClass());
        }
        return answer;
    }

    public boolean isIsGetterVisible(Method method) {
        boolean answer = this.defaultChecker.isIsGetterVisible(method);
        if (answer) {
            answer = this.isGetterMethodWithFieldVisible(method, this.getIsGetterFieldName(method.getName()), method.getDeclaringClass()) && this.isGetterMethodRetItselfVisible(method, method.getDeclaringClass());
        }
        return answer;
    }

    protected String getIsGetterFieldName(String methodName) {
        return Introspector.decapitalize(methodName.substring(2));
    }

    protected String getGetterFieldName(String methodName) {
        return Introspector.decapitalize(methodName.substring(3));
    }

    protected boolean isGetterMethodWithFieldVisible(Object method, String fieldName, Class<?> declaringClass) {
        int fieldModifiers;
        Field field = IgnorePropertiesBackedByTransientFields.findField(fieldName, declaringClass);
        if (field != null && Modifier.isTransient(fieldModifiers = field.getModifiers())) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ignoring getter " + method + " due to transient field called " + fieldName);
            }
            return false;
        }
        return true;
    }

    protected boolean isGetterMethodRetItselfVisible(Method method, Class<?> declaringClass) {
        if (method != null && method.getReturnType().getName().equals(declaringClass.getName())) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ignoring getter " + method + " due to return same type as declaringClass itself");
            }
            return false;
        }
        return true;
    }

    public boolean isCreatorVisible(AnnotatedMember m) {
        return this.defaultChecker.isCreatorVisible(m);
    }

    public boolean isCreatorVisible(Member m) {
        return this.defaultChecker.isCreatorVisible(m);
    }

    public boolean isFieldVisible(AnnotatedField f) {
        return this.defaultChecker.isFieldVisible(f);
    }

    public boolean isFieldVisible(Field f) {
        return this.defaultChecker.isFieldVisible(f);
    }

    public boolean isSetterVisible(AnnotatedMethod m) {
        return this.defaultChecker.isSetterVisible(m);
    }

    public boolean isSetterVisible(Method m) {
        return this.defaultChecker.isSetterVisible(m);
    }

    public IgnorePropertiesBackedByTransientFields with(JsonAutoDetect ann) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.with(ann));
    }

    public IgnorePropertiesBackedByTransientFields with(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.with(v));
    }

    public IgnorePropertiesBackedByTransientFields withCreatorVisibility(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withCreatorVisibility(v));
    }

    public IgnorePropertiesBackedByTransientFields withFieldVisibility(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withFieldVisibility(v));
    }

    public IgnorePropertiesBackedByTransientFields withGetterVisibility(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withGetterVisibility(v));
    }

    public IgnorePropertiesBackedByTransientFields withIsGetterVisibility(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withIsGetterVisibility(v));
    }

    public IgnorePropertiesBackedByTransientFields withSetterVisibility(JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withSetterVisibility(v));
    }

    public IgnorePropertiesBackedByTransientFields withVisibility(PropertyAccessor method, JsonAutoDetect.Visibility v) {
        return this.castToPropertiesBackedByTransientFields(this.defaultChecker.withVisibility(method, v));
    }

    protected IgnorePropertiesBackedByTransientFields castToPropertiesBackedByTransientFields(Object value) {
        if (value instanceof IgnorePropertiesBackedByTransientFields) {
            return (IgnorePropertiesBackedByTransientFields)value;
        }
        if (value != null) {
            if (value instanceof VisibilityChecker) {
                return new IgnorePropertiesBackedByTransientFields((VisibilityChecker)value);
            }
            LOG.warning("Could not convert value to IgnorePropertiesBackedByTransientFields as was " + value.getClass().getName() + " " + value);
        }
        return null;
    }

    protected static Field findField(String fieldName, Class<?> declaringClass) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass != declaringClass) {
                return IgnorePropertiesBackedByTransientFields.findField(fieldName, superclass);
            }
            return null;
        }
    }
}

