/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiException
extends Exception {
    private Collection<Throwable> causes = new ArrayList<Throwable>();

    public MultiException(String message) {
        super(message);
    }

    public MultiException(String message, Collection<Throwable> causes) {
        super(message);
        this.causes.addAll(causes);
    }

    public void addCause(Throwable e) {
        this.causes.add(e);
    }

    public void throwIfCauses() throws MultiException {
        if (!this.causes.isEmpty()) {
            throw this;
        }
    }

    public Throwable[] getCauses() {
        return this.causes.toArray(new Throwable[this.causes.size()]);
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        for (Throwable t : this.causes) {
            t.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        for (Throwable t : this.causes) {
            t.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        for (Throwable t : this.causes) {
            t.printStackTrace(out);
        }
    }

    public static void throwIf(String message, List<Throwable> throwables) throws MultiException {
        if (throwables != null && !throwables.isEmpty()) {
            StringBuilder sb = new StringBuilder(message);
            sb.append(":");
            for (Throwable t : throwables) {
                sb.append("\n\t");
                sb.append(t.getMessage());
            }
            throw new MultiException(sb.toString(), throwables);
        }
    }
}

